/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class DeploymentOptions {
    public static final ConfigOption<String> TARGET = ConfigOptions.key("execution.target").stringType().noDefaultValue().withDescription(Description.builder().text("The deployment target for the execution. This can take one of the following values:").list(TextElement.text("remote"), TextElement.text("local"), TextElement.text("yarn-per-job"), TextElement.text("yarn-session"), TextElement.text("kubernetes-session")).text(".").build());
    public static final ConfigOption<Boolean> ATTACHED = ConfigOptions.key("execution.attached").booleanType().defaultValue(false).withDescription("Specifies if the pipeline is submitted in attached or detached mode.");
    public static final ConfigOption<Boolean> SHUTDOWN_IF_ATTACHED = ConfigOptions.key("execution.shutdown-on-attached-exit").booleanType().defaultValue(false).withDescription("If the job is submitted in attached mode, perform a best-effort cluster shutdown when the CLI is terminated abruptly, e.g., in response to a user interrupt, such as typing Ctrl + C.");
    public static final ConfigOption<List<String>> JOB_LISTENERS = ConfigOptions.key("execution.job-listeners").stringType().asList().noDefaultValue().withDescription("Custom JobListeners to be registered with the execution environment. The registered listeners cannot have constructors with arguments.");
}

