/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.HeartbeatManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.SchedulerExecutionMode;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class JobManagerOptions {
    public static final MemorySize MIN_JVM_HEAP_SIZE = MemorySize.ofMebiBytes(128L);
    @Documentation.Section(value={"common_host_port", "all_jobmanager"})
    public static final ConfigOption<String> ADDRESS = ConfigOptions.key("jobmanager.rpc.address").noDefaultValue().withDescription("The config parameter defining the network address to connect to for communication with the job manager. This value is only interpreted in setups where a single JobManager with static name or address exists (simple standalone setups, or container setups with dynamic service name resolution). It is not used in many high-availability setups, when a leader-election service (like ZooKeeper) is used to elect and discover the JobManager leader from potentially multiple standby JobManagers.");
    public static final ConfigOption<String> BIND_HOST = ConfigOptions.key("jobmanager.bind-host").stringType().noDefaultValue().withDescription("The local address of the network interface that the job manager binds to. If not configured, '0.0.0.0' will be used.");
    @Documentation.Section(value={"common_host_port", "all_jobmanager"})
    public static final ConfigOption<Integer> PORT = ConfigOptions.key("jobmanager.rpc.port").defaultValue(6123).withDescription("The config parameter defining the network port to connect to for communication with the job manager. Like " + ADDRESS.key() + ", this value is only interpreted in setups where a single JobManager with static name/address and port exists (simple standalone setups, or container setups with dynamic service name resolution). This config option is not used in many high-availability setups, when a leader-election service (like ZooKeeper) is used to elect and discover the JobManager leader from potentially multiple standby JobManagers.");
    public static final ConfigOption<Integer> RPC_BIND_PORT = ConfigOptions.key("jobmanager.rpc.bind-port").intType().noDefaultValue().withDescription("The local RPC port that the JobManager binds to. If not configured, the external port (configured by '" + PORT.key() + "') will be used.");
    @Deprecated
    @Documentation.Section(value={"all_jobmanager"})
    public static final ConfigOption<MemorySize> JOB_MANAGER_HEAP_MEMORY = ConfigOptions.key("jobmanager.heap.size").memoryType().noDefaultValue().withDescription("JVM heap size for the JobManager.");
    @Deprecated
    public static final ConfigOption<Integer> JOB_MANAGER_HEAP_MEMORY_MB = ConfigOptions.key("jobmanager.heap.mb").intType().noDefaultValue().withDescription("JVM heap size (in megabytes) for the JobManager.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> TOTAL_PROCESS_MEMORY = ConfigOptions.key("jobmanager.memory.process.size").memoryType().noDefaultValue().withDescription("Total Process Memory size for the JobManager. This includes all the memory that a JobManager JVM process consumes, consisting of Total Flink Memory, JVM Metaspace, and JVM Overhead. In containerized setups, this should be set to the container memory. See also 'jobmanager.memory.flink.size' for Total Flink Memory size configuration.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> TOTAL_FLINK_MEMORY = ConfigOptions.key("jobmanager.memory.flink.size").memoryType().noDefaultValue().withDescription(String.format("Total Flink Memory size for the JobManager. This includes all the memory that a JobManager consumes, except for JVM Metaspace and JVM Overhead. It consists of JVM Heap Memory and Off-heap Memory. See also '%s' for total process memory size configuration.", TOTAL_PROCESS_MEMORY.key()));
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> JVM_HEAP_MEMORY = ConfigOptions.key("jobmanager.memory.heap.size").memoryType().noDefaultValue().withDescription("JVM Heap Memory size for JobManager. The minimum recommended JVM Heap size is " + MIN_JVM_HEAP_SIZE.toHumanReadableString() + '.');
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> OFF_HEAP_MEMORY = ConfigOptions.key("jobmanager.memory.off-heap.size").memoryType().defaultValue(MemorySize.ofMebiBytes(128L)).withDescription(Description.builder().text("Off-heap Memory size for JobManager. This option covers all off-heap memory usage including direct and native memory allocation. The JVM direct memory limit of the JobManager process (-XX:MaxDirectMemorySize) will be set to this value if the limit is enabled by 'jobmanager.memory.enable-jvm-direct-memory-limit'. ").build());
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<Boolean> JVM_DIRECT_MEMORY_LIMIT_ENABLED = ConfigOptions.key("jobmanager.memory.enable-jvm-direct-memory-limit").booleanType().defaultValue(false).withDescription(Description.builder().text("Whether to enable the JVM direct memory limit of the JobManager process (-XX:MaxDirectMemorySize). The limit will be set to the value of '%s' option. ", TextElement.text(OFF_HEAP_MEMORY.key())).build());
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> JVM_METASPACE = ConfigOptions.key("jobmanager.memory.jvm-metaspace.size").memoryType().defaultValue(MemorySize.ofMebiBytes(256L)).withDescription("JVM Metaspace Size for the JobManager.");
    private static final String JVM_OVERHEAD_DESCRIPTION = "This is off-heap memory reserved for JVM overhead, such as thread stack space, compile cache, etc. This includes native memory but not direct memory, and will not be counted when Flink calculates JVM max direct memory size parameter. The size of JVM Overhead is derived to make up the configured fraction of the Total Process Memory. If the derived size is less or greater than the configured min or max size, the min or max size will be used. The exact size of JVM Overhead can be explicitly specified by setting the min and max size to the same value.";
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> JVM_OVERHEAD_MIN = ConfigOptions.key("jobmanager.memory.jvm-overhead.min").memoryType().defaultValue(MemorySize.ofMebiBytes(192L)).withDescription("Min JVM Overhead size for the JobManager. This is off-heap memory reserved for JVM overhead, such as thread stack space, compile cache, etc. This includes native memory but not direct memory, and will not be counted when Flink calculates JVM max direct memory size parameter. The size of JVM Overhead is derived to make up the configured fraction of the Total Process Memory. If the derived size is less or greater than the configured min or max size, the min or max size will be used. The exact size of JVM Overhead can be explicitly specified by setting the min and max size to the same value.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<MemorySize> JVM_OVERHEAD_MAX = ConfigOptions.key("jobmanager.memory.jvm-overhead.max").memoryType().defaultValue(MemorySize.parse("1g")).withDescription("Max JVM Overhead size for the JobManager. This is off-heap memory reserved for JVM overhead, such as thread stack space, compile cache, etc. This includes native memory but not direct memory, and will not be counted when Flink calculates JVM max direct memory size parameter. The size of JVM Overhead is derived to make up the configured fraction of the Total Process Memory. If the derived size is less or greater than the configured min or max size, the min or max size will be used. The exact size of JVM Overhead can be explicitly specified by setting the min and max size to the same value.");
    @Documentation.Section(value={"common_memory"})
    public static final ConfigOption<Float> JVM_OVERHEAD_FRACTION = ConfigOptions.key("jobmanager.memory.jvm-overhead.fraction").floatType().defaultValue(Float.valueOf(0.1f)).withDescription("Fraction of Total Process Memory to be reserved for JVM Overhead. This is off-heap memory reserved for JVM overhead, such as thread stack space, compile cache, etc. This includes native memory but not direct memory, and will not be counted when Flink calculates JVM max direct memory size parameter. The size of JVM Overhead is derived to make up the configured fraction of the Total Process Memory. If the derived size is less or greater than the configured min or max size, the min or max size will be used. The exact size of JVM Overhead can be explicitly specified by setting the min and max size to the same value.");
    @Documentation.Section(value={"all_jobmanager"})
    public static final ConfigOption<Integer> MAX_ATTEMPTS_HISTORY_SIZE = ConfigOptions.key("jobmanager.execution.attempts-history-size").defaultValue(16).withDeprecatedKeys("job-manager.max-attempts-history-size").withDescription("The maximum number of prior execution attempts kept in history.");
    @Documentation.Section(value={"all_jobmanager", "expert_fault_tolerance"})
    public static final ConfigOption<String> EXECUTION_FAILOVER_STRATEGY = ConfigOptions.key("jobmanager.execution.failover-strategy").stringType().defaultValue("region").withDescription(Description.builder().text("This option specifies how the job computation recovers from task failures. Accepted values are:").list(TextElement.text("'full': Restarts all tasks to recover the job."), TextElement.text("'region': Restarts all tasks that could be affected by the task failure. More details can be found %s.", LinkElement.link("../dev/task_failure_recovery.html#restart-pipelined-region-failover-strategy", "here"))).build());
    @Documentation.Section(value={"all_jobmanager"})
    public static final ConfigOption<String> ARCHIVE_DIR = ConfigOptions.key("jobmanager.archive.fs.dir").noDefaultValue().withDescription("Dictionary for JobManager to store the archives of completed jobs.");
    @Documentation.Section(value={"all_jobmanager"})
    public static final ConfigOption<Long> JOB_STORE_CACHE_SIZE = ConfigOptions.key("jobstore.cache-size").defaultValue(0x3200000L).withDescription("The job store cache size in bytes which is used to keep completed jobs in memory.");
    @Documentation.Section(value={"all_jobmanager"})
    public static final ConfigOption<Long> JOB_STORE_EXPIRATION_TIME = ConfigOptions.key("jobstore.expiration-time").defaultValue(3600L).withDescription("The time in seconds after which a completed job expires and is purged from the job store.");
    @Documentation.Section(value={"all_jobmanager"})
    public static final ConfigOption<Integer> JOB_STORE_MAX_CAPACITY = ConfigOptions.key("jobstore.max-capacity").defaultValue(Integer.MAX_VALUE).withDescription("The max number of completed jobs that can be kept in the job store.");
    @Documentation.Section(value={"all_jobmanager"})
    public static final ConfigOption<Boolean> RETRIEVE_TASK_MANAGER_HOSTNAME = ConfigOptions.key("jobmanager.retrieve-taskmanager-hostname").defaultValue(true).withDescription("Flag indicating whether JobManager would retrieve canonical host name of TaskManager during registration. If the option is set to \"false\", TaskManager registration with JobManager could be faster, since no reverse DNS lookup is performed. However, local input split assignment (such as for HDFS files) may be impacted.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Long> SLOT_REQUEST_TIMEOUT = ConfigOptions.key("slot.request.timeout").defaultValue(300000L).withDescription("The timeout in milliseconds for requesting a slot from Slot Pool.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Long> SLOT_IDLE_TIMEOUT = ConfigOptions.key("slot.idle.timeout").defaultValue(HeartbeatManagerOptions.HEARTBEAT_TIMEOUT.defaultValue()).withDescription("The timeout in milliseconds for a idle slot in Slot Pool.");
    @Documentation.ExcludeFromDocumentation(value="SchedulerNG is still in development.")
    public static final ConfigOption<SchedulerType> SCHEDULER = ConfigOptions.key("jobmanager.scheduler").enumType(SchedulerType.class).defaultValue(SchedulerType.Ng).withDescription(Description.builder().text("Determines which scheduler implementation is used to schedule tasks. Accepted values are:").list(TextElement.text("'Ng': new generation scheduler"), TextElement.text("'Adaptive': adaptive scheduler; supports reactive mode")).build());
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<SchedulerExecutionMode> SCHEDULER_MODE = ConfigOptions.key("scheduler-mode").enumType(SchedulerExecutionMode.class).defaultValue(null).withDescription(Description.builder().text("Determines the mode of the scheduler. Note that %s=%s is only supported by standalone application deployments, not by active resource managers (YARN, Kubernetes) or session clusters.", TextElement.code("scheduler-mode"), TextElement.code(SchedulerExecutionMode.REACTIVE.name())).build());
    @Documentation.Section(value={"expert_scheduling", "all_jobmanager"})
    public static final ConfigOption<Integer> MIN_PARALLELISM_INCREASE = ConfigOptions.key("jobmanager.adaptive-scheduler.min-parallelism-increase").intType().defaultValue(1).withDescription("Configure the minimum increase in parallelism for a job to scale up.");
    @Documentation.Section(value={"expert_scheduling", "all_jobmanager"})
    public static final ConfigOption<Duration> RESOURCE_WAIT_TIMEOUT = ConfigOptions.key("jobmanager.adaptive-scheduler.resource-wait-timeout").durationType().defaultValue(Duration.ofMinutes(5L)).withDescription(Description.builder().text("The maximum time the JobManager will wait to acquire all required resources after a job submission or restart. Once elapsed it will try to run the job with a lower parallelism, or fail if the minimum amount of resources could not be acquired.").linebreak().text("Increasing this value will make the cluster more resilient against temporary resources shortages (e.g., there is more time for a failed TaskManager to be restarted).").linebreak().text("Setting a negative duration will disable the resource timeout: The JobManager will wait indefinitely for resources to appear.").linebreak().text("If %s is configured to %s, this configuration value will default to a negative value to disable the resource timeout.", TextElement.code(SCHEDULER_MODE.key()), TextElement.code(SchedulerExecutionMode.REACTIVE.name())).build());
    @Documentation.Section(value={"expert_scheduling", "all_jobmanager"})
    public static final ConfigOption<Duration> RESOURCE_STABILIZATION_TIMEOUT = ConfigOptions.key("jobmanager.adaptive-scheduler.resource-stabilization-timeout").durationType().defaultValue(Duration.ofSeconds(10L)).withDescription(Description.builder().text("The resource stabilization timeout defines the time the JobManager will wait if fewer than the desired but sufficient resources are available. The timeout starts once sufficient resources for running the job are available. Once this timeout has passed, the job will start executing with the available resources.").linebreak().text("If %s is configured to %s, this configuration value will default to 0, so that jobs are starting immediately with the available resources.", TextElement.code(SCHEDULER_MODE.key()), TextElement.code(SchedulerExecutionMode.REACTIVE.name())).build());
    @Documentation.ExcludeFromDocumentation(value="User normally should not be expected to deactivate this feature. We aim at removing this flag eventually.")
    public static final ConfigOption<Boolean> PARTITION_RELEASE_DURING_JOB_EXECUTION = ConfigOptions.key("jobmanager.partition.release-during-job-execution").defaultValue(true).withDescription("Controls whether partitions should already be released during the job execution.");

    private JobManagerOptions() {
        throw new IllegalAccessError();
    }

    public static enum SchedulerType {
        Ng,
        Adaptive;

    }
}

