/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.EitherTypeInfo;
import org.apache.flink.types.Either;

public class EitherTypeInfoFactory<L, R>
extends TypeInfoFactory<Either<L, R>> {
    @Override
    public TypeInformation<Either<L, R>> createTypeInfo(Type t, Map<String, TypeInformation<?>> genericParameters) {
        TypeInformation<?> leftType = genericParameters.get("L");
        TypeInformation<?> rightType = genericParameters.get("R");
        if (leftType == null) {
            throw new InvalidTypesException("Type extraction is not possible on Either type as it does not contain information about the 'left' type.");
        }
        if (rightType == null) {
            throw new InvalidTypesException("Type extraction is not possible on Either type as it does not contain information about the 'right' type.");
        }
        return new EitherTypeInfo(leftType, rightType);
    }
}

