/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.fs.FSDataInputStream;

@Public
public class InputStreamFSInputWrapper
extends FSDataInputStream {
    private final InputStream inStream;
    private long pos = 0L;

    public InputStreamFSInputWrapper(InputStream inStream) {
        this.inStream = inStream;
    }

    @Override
    public void close() throws IOException {
        this.inStream.close();
    }

    @Override
    public void seek(long desired) throws IOException {
        if (desired < this.pos) {
            throw new IllegalArgumentException("Wrapped InputStream: cannot search backwards.");
        }
        while (this.pos < desired) {
            long numReadBytes = this.inStream.skip(desired - this.pos);
            if (numReadBytes == -1L) {
                throw new EOFException("Unexpected EOF during forward seek.");
            }
            this.pos += numReadBytes;
        }
    }

    @Override
    public long getPos() throws IOException {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        int read = this.inStream.read();
        if (read != -1) {
            ++this.pos;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int numReadBytes = this.inStream.read(b, off, len);
        if (numReadBytes != -1) {
            this.pos += (long)numReadBytes;
        }
        return numReadBytes;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

