/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentWritable;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.util.Preconditions;
import sun.misc.Unsafe;

public class DataOutputSerializer
implements DataOutputView,
MemorySegmentWritable {
    private byte[] buffer;
    private int position;
    private ByteBuffer wrapper;
    private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    private static final long BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final boolean LITTLE_ENDIAN = MemoryUtils.NATIVE_BYTE_ORDER == ByteOrder.LITTLE_ENDIAN;

    public DataOutputSerializer(int startSize) {
        if (startSize < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = new byte[startSize];
        this.wrapper = ByteBuffer.wrap(this.buffer);
    }

    public ByteBuffer wrapAsByteBuffer() {
        this.wrapper.position(0);
        this.wrapper.limit(this.position);
        return this.wrapper;
    }

    @Deprecated
    public byte[] getByteArray() {
        return this.getSharedBuffer();
    }

    public byte[] getSharedBuffer() {
        return this.buffer;
    }

    public byte[] getCopyOfBuffer() {
        return Arrays.copyOf(this.buffer, this.position);
    }

    public void clear() {
        this.position = 0;
    }

    public int length() {
        return this.position;
    }

    public String toString() {
        return String.format("[pos=%d cap=%d]", this.position, this.buffer.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.position >= this.buffer.length) {
            this.resize(1);
        }
        this.buffer[this.position++] = (byte)(b & 0xFF);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.position > this.buffer.length - len) {
            this.resize(len);
        }
        System.arraycopy(b, off, this.buffer, this.position, len);
        this.position += len;
    }

    @Override
    public void write(MemorySegment segment, int off, int len) throws IOException {
        if (len < 0 || off < 0 || off > segment.size() - len) {
            throw new IndexOutOfBoundsException(String.format("offset: %d, length: %d, size: %d", off, len, segment.size()));
        }
        if (this.position > this.buffer.length - len) {
            this.resize(len);
        }
        segment.get(off, this.buffer, this.position, len);
        this.position += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int sLen = s.length();
        if (this.position >= this.buffer.length - sLen) {
            this.resize(sLen);
        }
        for (int i = 0; i < sLen; ++i) {
            this.writeByte(s.charAt(i));
        }
        this.position += sLen;
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.position >= this.buffer.length - 1) {
            this.resize(2);
        }
        this.buffer[this.position++] = (byte)(v >> 8);
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public void writeChars(String s) throws IOException {
        int sLen = s.length();
        if (this.position >= this.buffer.length - 2 * sLen) {
            this.resize(2 * sLen);
        }
        for (int i = 0; i < sLen; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.position >= this.buffer.length - 3) {
            this.resize(4);
        }
        if (LITTLE_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        UNSAFE.putInt(this.buffer, BASE_OFFSET + (long)this.position, v);
        this.position += 4;
    }

    public void writeIntUnsafe(int v, int pos) throws IOException {
        if (LITTLE_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        UNSAFE.putInt(this.buffer, BASE_OFFSET + (long)pos, v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.position >= this.buffer.length - 7) {
            this.resize(8);
        }
        if (LITTLE_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        UNSAFE.putLong(this.buffer, BASE_OFFSET + (long)this.position, v);
        this.position += 8;
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.position >= this.buffer.length - 1) {
            this.resize(2);
        }
        this.buffer[this.position++] = (byte)(v >>> 8 & 0xFF);
        this.buffer[this.position++] = (byte)(v & 0xFF);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            utflen += this.getUTFBytesSize(c);
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("Encoded string is too long: " + utflen);
        }
        if (this.position > this.buffer.length - utflen - 2) {
            this.resize(utflen + 2);
        }
        byte[] bytearr = this.buffer;
        bytearr[this.position++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[this.position++] = (byte)(utflen & 0xFF);
        this.writeUTFBytes(str);
    }

    public void writeLongUTF(String str) throws IOException {
        int strlen = str.length();
        long utflen = 0L;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if ((utflen += (long)this.getUTFBytesSize(c)) <= Integer.MAX_VALUE) continue;
            throw new UTFDataFormatException("Encoded string reached maximum length: " + utflen);
        }
        if (utflen > 0x7FFFFFFBL) {
            throw new UTFDataFormatException("Encoded string is too long: " + utflen);
        }
        if ((long)this.position > (long)this.buffer.length - utflen - 2L) {
            this.resize((int)utflen + 4);
        }
        this.writeInt((int)utflen);
        this.writeUTFBytes(str);
    }

    private void writeUTFBytes(String str) {
        char c;
        int i;
        int strlen = str.length();
        byte[] bytearr = this.buffer;
        int count = this.position;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        this.position = count;
    }

    private int getUTFBytesSize(int c) {
        if (c >= 1 && c <= 127) {
            return 1;
        }
        if (c > 2047) {
            return 3;
        }
        return 2;
    }

    private void resize(int minCapacityAdd) throws IOException {
        byte[] nb;
        int newLen = Math.max(this.buffer.length * 2, this.buffer.length + minCapacityAdd);
        try {
            nb = new byte[newLen];
        }
        catch (NegativeArraySizeException e) {
            throw new IOException("Serialization failed because the record length would exceed 2GB (max addressable array size in Java).");
        }
        catch (OutOfMemoryError e) {
            if (newLen > this.buffer.length + minCapacityAdd) {
                newLen = this.buffer.length + minCapacityAdd;
                try {
                    nb = new byte[newLen];
                }
                catch (OutOfMemoryError ee) {
                    throw new IOException("Failed to serialize element. Serialized size (> " + newLen + " bytes) exceeds JVM heap space", ee);
                }
            }
            throw new IOException("Failed to serialize element. Serialized size (> " + newLen + " bytes) exceeds JVM heap space", e);
        }
        System.arraycopy(this.buffer, 0, nb, 0, this.position);
        this.buffer = nb;
        this.wrapper = ByteBuffer.wrap(this.buffer);
    }

    @Override
    public void skipBytesToWrite(int numBytes) throws IOException {
        if (this.buffer.length - this.position < numBytes) {
            throw new EOFException("Could not skip " + numBytes + " bytes.");
        }
        this.position += numBytes;
    }

    @Override
    public void write(DataInputView source, int numBytes) throws IOException {
        if (this.buffer.length - this.position < numBytes) {
            throw new EOFException("Could not write " + numBytes + " bytes. Buffer overflow.");
        }
        source.readFully(this.buffer, this.position, numBytes);
        this.position += numBytes;
    }

    public void setPosition(int position) {
        Preconditions.checkArgument(position >= 0 && position <= this.position, "Position out of bounds.");
        this.position = position;
    }

    public void setPositionUnsafe(int position) {
        this.position = position;
    }
}

