/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.state;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;

@Internal
public class CompletedStateFuture<T>
implements InternalStateFuture<T> {
    T result;

    CompletedStateFuture(T result) {
        this.result = result;
    }

    public <U> StateFuture<U> thenApply(FunctionWithException<? super T, ? extends U, ? extends Exception> fn) {
        return StateFutureUtils.completedFuture(FunctionWithException.unchecked(fn).apply(this.result));
    }

    public StateFuture<Void> thenAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        ThrowingConsumer.unchecked(action).accept(this.result);
        return StateFutureUtils.completedVoidFuture();
    }

    public <U> StateFuture<U> thenCompose(FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> action) {
        return (StateFuture)FunctionWithException.unchecked(action).apply(this.result);
    }

    public <U, V> StateFuture<V> thenCombine(StateFuture<? extends U> other, BiFunctionWithException<? super T, ? super U, ? extends V, ? extends Exception> fn) {
        return other.thenCompose(u -> {
            Object v = fn.apply(this.result, u);
            return StateFutureUtils.completedFuture(v);
        });
    }

    @Override
    public void complete(T result) {
        throw new UnsupportedOperationException("This state future has already been completed.");
    }

    @Override
    public void completeExceptionally(String message, Throwable ex) {
        throw new UnsupportedOperationException("This state future has already been completed.");
    }

    @Override
    public void thenSyncAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        ThrowingConsumer.unchecked(action).accept(this.result);
    }
}

