/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.configuration.Configuration;

@Internal
public abstract class PlanExecutor {
    private static final String LOCAL_EXECUTOR_CLASS = "org.apache.flink.client.LocalExecutor";
    private static final String REMOTE_EXECUTOR_CLASS = "org.apache.flink.client.RemoteExecutor";
    private boolean printUpdatesToSysout = true;

    public void setPrintStatusDuringExecution(boolean printStatus) {
        this.printUpdatesToSysout = printStatus;
    }

    public boolean isPrintingStatusDuringExecution() {
        return this.printUpdatesToSysout;
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract boolean isRunning();

    public abstract JobExecutionResult executePlan(Plan var1) throws Exception;

    public abstract String getOptimizerPlanAsJSON(Plan var1) throws Exception;

    public abstract void endSession(JobID var1) throws Exception;

    public static PlanExecutor createLocalExecutor(Configuration configuration) {
        Class<? extends PlanExecutor> leClass = PlanExecutor.loadExecutorClass(LOCAL_EXECUTOR_CLASS);
        try {
            return leClass.getConstructor(Configuration.class).newInstance(configuration);
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred while loading the local executor (org.apache.flink.client.LocalExecutor).", t);
        }
    }

    public static PlanExecutor createRemoteExecutor(String hostname, int port, Configuration clientConfiguration, List<URL> jarFiles, List<URL> globalClasspaths) {
        if (hostname == null) {
            throw new IllegalArgumentException("The hostname must not be null.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("The port value is out of range.");
        }
        Class<? extends PlanExecutor> reClass = PlanExecutor.loadExecutorClass(REMOTE_EXECUTOR_CLASS);
        List<Object> files = jarFiles == null ? Collections.emptyList() : jarFiles;
        List<Object> paths = globalClasspaths == null ? Collections.emptyList() : globalClasspaths;
        try {
            PlanExecutor executor = clientConfiguration == null ? reClass.getConstructor(String.class, Integer.TYPE, List.class).newInstance(hostname, port, files) : reClass.getConstructor(String.class, Integer.TYPE, Configuration.class, List.class, List.class).newInstance(hostname, port, clientConfiguration, files, paths);
            return executor;
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred while loading the remote executor (org.apache.flink.client.RemoteExecutor).", t);
        }
    }

    private static Class<? extends PlanExecutor> loadExecutorClass(String className) {
        try {
            Class<?> leClass = Class.forName(className);
            return leClass.asSubclass(PlanExecutor.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load the executor class (" + className + "). Do you have the 'flink-clients' project in your dependencies?");
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred while loading the executor (" + className + ").", t);
        }
    }
}

