/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public abstract class CompositeSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    protected final TypeSerializer<Object>[] fieldSerializers;
    final PrecomputedParameters precomputed;

    protected CompositeSerializer(boolean immutableTargetType, TypeSerializer<?> ... fieldSerializers) {
        this(PrecomputedParameters.precompute(immutableTargetType, fieldSerializers), fieldSerializers);
    }

    protected CompositeSerializer(PrecomputedParameters precomputed, TypeSerializer<?> ... fieldSerializers) {
        this.fieldSerializers = fieldSerializers;
        this.precomputed = precomputed;
    }

    public abstract T createInstance(Object ... var1);

    protected abstract void setField(@Nonnull T var1, int var2, Object var3);

    protected abstract Object getField(@Nonnull T var1, int var2);

    protected abstract CompositeSerializer<T> createSerializerInstance(PrecomputedParameters var1, TypeSerializer<?> ... var2);

    @Override
    public CompositeSerializer<T> duplicate() {
        return this.precomputed.stateful ? this.createSerializerInstance(this.precomputed, CompositeSerializer.duplicateFieldSerializers(this.fieldSerializers)) : this;
    }

    private static TypeSerializer[] duplicateFieldSerializers(TypeSerializer<Object>[] fieldSerializers) {
        TypeSerializer[] duplicatedSerializers = new TypeSerializer[fieldSerializers.length];
        for (int index = 0; index < fieldSerializers.length; ++index) {
            duplicatedSerializers[index] = fieldSerializers[index].duplicate();
            assert (duplicatedSerializers[index] != null);
        }
        return duplicatedSerializers;
    }

    @Override
    public boolean isImmutableType() {
        return this.precomputed.immutable;
    }

    @Override
    public T createInstance() {
        Object[] fields = new Object[this.fieldSerializers.length];
        for (int index = 0; index < this.fieldSerializers.length; ++index) {
            fields[index] = this.fieldSerializers[index].createInstance();
        }
        return this.createInstance(fields);
    }

    @Override
    public T copy(T from) {
        Preconditions.checkNotNull(from);
        if (this.isImmutableType()) {
            return from;
        }
        Object[] fields = new Object[this.fieldSerializers.length];
        for (int index = 0; index < this.fieldSerializers.length; ++index) {
            fields[index] = this.fieldSerializers[index].copy(this.getField(from, index));
        }
        return this.createInstance(fields);
    }

    @Override
    public T copy(T from, T reuse) {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(reuse);
        if (this.isImmutableType()) {
            return from;
        }
        Object[] fields = new Object[this.fieldSerializers.length];
        for (int index = 0; index < this.fieldSerializers.length; ++index) {
            fields[index] = this.fieldSerializers[index].copy(this.getField(from, index), this.getField(reuse, index));
        }
        return this.createInstanceWithReuse(fields, reuse);
    }

    @Override
    public int getLength() {
        return this.precomputed.length;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        Preconditions.checkNotNull(record);
        Preconditions.checkNotNull(target);
        for (int index = 0; index < this.fieldSerializers.length; ++index) {
            this.fieldSerializers[index].serialize(this.getField(record, index), target);
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        Preconditions.checkNotNull(source);
        Object[] fields = new Object[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            fields[i] = this.fieldSerializers[i].deserialize(source);
        }
        return this.createInstance(fields);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        Preconditions.checkNotNull(reuse);
        Preconditions.checkNotNull(source);
        Object[] fields = new Object[this.fieldSerializers.length];
        for (int index = 0; index < this.fieldSerializers.length; ++index) {
            fields[index] = this.fieldSerializers[index].deserialize(this.getField(reuse, index), source);
        }
        return this.precomputed.immutable ? this.createInstance(fields) : this.createInstanceWithReuse(fields, reuse);
    }

    private T createInstanceWithReuse(Object[] fields, T reuse) {
        for (int index = 0; index < fields.length; ++index) {
            this.setField(reuse, index, fields[index]);
        }
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(target);
        for (TypeSerializer<Object> typeSerializer : this.fieldSerializers) {
            typeSerializer.copy(source, target);
        }
    }

    @Override
    public int hashCode() {
        return 31 * Boolean.hashCode(this.precomputed.immutableTargetType) + Arrays.hashCode(this.fieldSerializers);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            CompositeSerializer other = (CompositeSerializer)obj;
            return this.precomputed.immutable == other.precomputed.immutable && Arrays.equals(this.fieldSerializers, other.fieldSerializers);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ConfigSnapshot(this.fieldSerializers);
    }

    @Override
    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> previousSerializersAndConfigs;
        if (configSnapshot instanceof ConfigSnapshot && (previousSerializersAndConfigs = ((CompositeTypeSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs()).size() == this.fieldSerializers.length) {
            return this.ensureFieldCompatibility(previousSerializersAndConfigs);
        }
        return CompatibilityResult.requiresMigration();
    }

    private CompatibilityResult<T> ensureFieldCompatibility(List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> previousSerializersAndConfigs) {
        TypeSerializer[] convertSerializers = new TypeSerializer[this.fieldSerializers.length];
        boolean requiresMigration = false;
        for (int index = 0; index < previousSerializersAndConfigs.size(); ++index) {
            CompatibilityResult<Object> compatResult = this.resolveFieldCompatibility(previousSerializersAndConfigs, index);
            if (!compatResult.isRequiresMigration()) continue;
            requiresMigration = true;
            if (compatResult.getConvertDeserializer() != null) {
                convertSerializers[index] = new TypeDeserializerAdapter<Object>(compatResult.getConvertDeserializer());
                continue;
            }
            return CompatibilityResult.requiresMigration();
        }
        return requiresMigration ? this.createMigrationCompatResult(convertSerializers) : CompatibilityResult.compatible();
    }

    private CompatibilityResult<Object> resolveFieldCompatibility(List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> previousSerializersAndConfigs, int index) {
        return CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)previousSerializersAndConfigs.get((int)index).f0, UnloadableDummyTypeSerializer.class, (TypeSerializerSnapshot)previousSerializersAndConfigs.get((int)index).f1, this.fieldSerializers[index]);
    }

    private CompatibilityResult<T> createMigrationCompatResult(TypeSerializer<Object>[] convertSerializers) {
        PrecomputedParameters precomputed = PrecomputedParameters.precompute(this.precomputed.immutableTargetType, convertSerializers);
        return CompatibilityResult.requiresMigration(this.createSerializerInstance(precomputed, convertSerializers));
    }

    public static class ConfigSnapshot
    extends CompositeTypeSerializerConfigSnapshot {
        private static final int VERSION = 0;

        public ConfigSnapshot() {
        }

        ConfigSnapshot(TypeSerializer<?> ... nestedSerializers) {
            super(nestedSerializers);
        }

        @Override
        public int getVersion() {
            return 0;
        }
    }

    protected static class PrecomputedParameters
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final boolean immutableTargetType;
        final boolean immutable;
        private final int length;
        final boolean stateful;

        private PrecomputedParameters(boolean immutableTargetType, boolean immutable, int length, boolean stateful) {
            this.immutableTargetType = immutableTargetType;
            this.immutable = immutable;
            this.length = length;
            this.stateful = stateful;
        }

        static PrecomputedParameters precompute(boolean immutableTargetType, TypeSerializer<Object>[] fieldSerializers) {
            Preconditions.checkNotNull(fieldSerializers);
            int totalLength = 0;
            boolean fieldsImmutable = true;
            boolean stateful = false;
            for (TypeSerializer<Object> fieldSerializer : fieldSerializers) {
                Preconditions.checkNotNull(fieldSerializer);
                if (fieldSerializer != fieldSerializer.duplicate()) {
                    stateful = true;
                }
                if (!fieldSerializer.isImmutableType()) {
                    fieldsImmutable = false;
                }
                if (fieldSerializer.getLength() < 0) {
                    totalLength = -1;
                }
                totalLength = totalLength >= 0 ? totalLength + fieldSerializer.getLength() : totalLength;
            }
            return new PrecomputedParameters(immutableTargetType, fieldsImmutable, totalLength, stateful);
        }
    }
}

