/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class CompositeSerializerSnapshot {
    private static final int MAGIC_NUMBER = 1333245;
    private static final int VERSION = 1;
    private final TypeSerializerSnapshot<?>[] nestedSnapshots;

    public CompositeSerializerSnapshot(TypeSerializer<?> ... serializers) {
        this.nestedSnapshots = TypeSerializerUtils.snapshotBackwardsCompatible(serializers);
    }

    private CompositeSerializerSnapshot(TypeSerializerSnapshot<?>[] snapshots) {
        this.nestedSnapshots = snapshots;
    }

    public TypeSerializer<?>[] getRestoreSerializers() {
        return CompositeSerializerSnapshot.snapshotsToRestoreSerializers(this.nestedSnapshots);
    }

    public <T> TypeSerializer<T> getRestoreSerializer(int pos) {
        Preconditions.checkArgument(pos < this.nestedSnapshots.length);
        TypeSerializerSnapshot<?> snapshot = this.nestedSnapshots[pos];
        return snapshot.restoreSerializer();
    }

    public <T> TypeSerializerSchemaCompatibility<T> resolveCompatibilityWithNested(TypeSerializerSchemaCompatibility<?> outerCompatibility, TypeSerializer<?> ... newNestedSerializers) {
        Preconditions.checkArgument(newNestedSerializers.length == this.nestedSnapshots.length, "Different number of new serializers and existing serializer configuration snapshots");
        if (outerCompatibility.isIncompatible()) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        boolean nestedSerializerRequiresMigration = false;
        for (int i = 0; i < this.nestedSnapshots.length; ++i) {
            TypeSerializerSchemaCompatibility compatibility = CompositeSerializerSnapshot.resolveCompatibility(newNestedSerializers[i], this.nestedSnapshots[i]);
            if (compatibility.isIncompatible()) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            if (!compatibility.isCompatibleAfterMigration()) continue;
            nestedSerializerRequiresMigration = true;
        }
        return nestedSerializerRequiresMigration || !outerCompatibility.isCompatibleAsIs() ? TypeSerializerSchemaCompatibility.compatibleAfterMigration() : TypeSerializerSchemaCompatibility.compatibleAsIs();
    }

    public final void writeCompositeSnapshot(DataOutputView out) throws IOException {
        out.writeInt(1333245);
        out.writeInt(1);
        out.writeInt(this.nestedSnapshots.length);
        for (TypeSerializerSnapshot<?> snap : this.nestedSnapshots) {
            TypeSerializerSnapshot.writeVersionedSnapshot(out, snap);
        }
    }

    public static CompositeSerializerSnapshot readCompositeSnapshot(DataInputView in, ClassLoader cl) throws IOException {
        int magicNumber = in.readInt();
        if (magicNumber != 1333245) {
            throw new IOException(String.format("Corrupt data, magic number mismatch. Expected %8x, found %8x", 1333245, magicNumber));
        }
        int version = in.readInt();
        if (version != 1) {
            throw new IOException("Unrecognized version: " + version);
        }
        int numSnapshots = in.readInt();
        TypeSerializerSnapshot[] nestedSnapshots = new TypeSerializerSnapshot[numSnapshots];
        for (int i = 0; i < numSnapshots; ++i) {
            nestedSnapshots[i] = TypeSerializerSnapshot.readVersionedSnapshot(in, cl);
        }
        return new CompositeSerializerSnapshot(nestedSnapshots);
    }

    public static CompositeSerializerSnapshot legacyReadProductSnapshots(DataInputView in, ClassLoader cl) throws IOException {
        List<Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> serializersAndSnapshots = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience(in, cl);
        TypeSerializerSnapshot[] nestedSnapshots = (TypeSerializerSnapshot[])serializersAndSnapshots.stream().map(t -> (TypeSerializerSnapshot)t.f1).toArray(TypeSerializerSnapshot[]::new);
        return new CompositeSerializerSnapshot(nestedSnapshots);
    }

    private static <E> TypeSerializerSchemaCompatibility<E> resolveCompatibility(TypeSerializer<?> serializer, TypeSerializerSnapshot<?> snapshot) {
        TypeSerializer<?> typedSerializer = serializer;
        TypeSerializerSnapshot<?> typedSnapshot = snapshot;
        return typedSnapshot.resolveSchemaCompatibility(typedSerializer);
    }

    private static TypeSerializer<?>[] snapshotsToRestoreSerializers(TypeSerializerSnapshot<?> ... snapshots) {
        return (TypeSerializer[])Arrays.stream(snapshots).map(TypeSerializerSnapshot::restoreSerializer).toArray(TypeSerializer[]::new);
    }
}

