/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class LongComparator
extends BasicTypeComparator<Long> {
    private static final long serialVersionUID = 1L;

    public LongComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        long l2;
        long l1 = firstSource.readLong();
        int comp = l1 < (l2 = secondSource.readLong()) ? -1 : (l1 == l2 ? 0 : 1);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 8;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 8;
    }

    @Override
    public void putNormalizedKey(Long lValue, MemorySegment target, int offset, int numBytes) {
        block5: {
            long value;
            block4: {
                value = lValue - Long.MIN_VALUE;
                if (numBytes != 8) break block4;
                target.putLongBigEndian(offset, value);
                break block5;
            }
            if (numBytes <= 0) break block5;
            if (numBytes < 8) {
                int i = 0;
                while (numBytes > 0) {
                    target.put(offset + i, (byte)(value >>> (7 - i << 3)));
                    --numBytes;
                    ++i;
                }
            } else {
                target.putLongBigEndian(offset, value);
                for (int i = 8; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public LongComparator duplicate() {
        return new LongComparator(this.ascendingComparison);
    }
}

