/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class BooleanPrimitiveArraySerializer
extends TypeSerializerSingleton<boolean[]> {
    private static final long serialVersionUID = 1L;
    private static final boolean[] EMPTY = new boolean[0];
    public static final BooleanPrimitiveArraySerializer INSTANCE = new BooleanPrimitiveArraySerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public boolean[] createInstance() {
        return EMPTY;
    }

    @Override
    public boolean[] copy(boolean[] from) {
        boolean[] copy = new boolean[from.length];
        System.arraycopy(from, 0, copy, 0, from.length);
        return copy;
    }

    @Override
    public boolean[] copy(boolean[] from, boolean[] reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(boolean[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            target.writeBoolean(record[i]);
        }
    }

    @Override
    public boolean[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        boolean[] result = new boolean[len];
        for (int i = 0; i < len; ++i) {
            result[i] = source.readBoolean();
        }
        return result;
    }

    @Override
    public boolean[] deserialize(boolean[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BooleanPrimitiveArraySerializer;
    }

    @Override
    public TypeSerializerSnapshot<boolean[]> snapshotConfiguration() {
        return new BooleanPrimitiveArraySerializerSnapshot();
    }

    public static final class BooleanPrimitiveArraySerializerSnapshot
    extends SimpleTypeSerializerSnapshot<boolean[]> {
        public BooleanPrimitiveArraySerializerSnapshot() {
            super(BooleanPrimitiveArraySerializer.class);
        }
    }
}

