/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;

@PublicEvolving
public class ResourceManagerOptions {
    public static final ConfigOption<String> JOB_TIMEOUT = ConfigOptions.key("resourcemanager.job.timeout").defaultValue("5 minutes").withDescription("Timeout for jobs which don't have a job manager as leader assigned.");
    public static final ConfigOption<Integer> LOCAL_NUMBER_RESOURCE_MANAGER = ConfigOptions.key("local.number-resourcemanager").defaultValue(1);
    public static final ConfigOption<Integer> IPC_PORT = ConfigOptions.key("resourcemanager.rpc.port").defaultValue(0).withDescription("Defines the network port to connect to for communication with the resource manager. By default, the port of the JobManager, because the same ActorSystem is used. Its not possible to use this configuration key to define port ranges.");
    public static final ConfigOption<Float> CONTAINERIZED_HEAP_CUTOFF_RATIO = ConfigOptions.key("containerized.heap-cutoff-ratio").defaultValue(Float.valueOf(0.25f)).withDeprecatedKeys("yarn.heap-cutoff-ratio").withDescription("Percentage of heap space to remove from containers (YARN / Mesos), to compensate for other JVM memory usage.");
    public static final ConfigOption<Integer> CONTAINERIZED_HEAP_CUTOFF_MIN = ConfigOptions.key("containerized.heap-cutoff-min").defaultValue(600).withDeprecatedKeys("yarn.heap-cutoff-min").withDescription("Minimum amount of heap memory to remove in containers, as a safety margin.");
    @Deprecated
    public static final ConfigOption<Long> SLOT_REQUEST_TIMEOUT = ConfigOptions.key("slotmanager.request-timeout").defaultValue(-1L).withDescription("The timeout for a slot request to be discarded.");
    @Deprecated
    public static final ConfigOption<Long> SLOT_MANAGER_TASK_MANAGER_TIMEOUT = ConfigOptions.key("slotmanager.taskmanager-timeout").defaultValue(30000L).withDescription("The timeout for an idle task manager to be released.");
    public static final ConfigOption<Long> TASK_MANAGER_TIMEOUT = ConfigOptions.key("resourcemanager.taskmanager-timeout").defaultValue(30000L).withDeprecatedKeys(SLOT_MANAGER_TASK_MANAGER_TIMEOUT.key()).withDescription(Description.builder().text("The timeout for an idle task manager to be released.").build());
    public static final String CONTAINERIZED_MASTER_ENV_PREFIX = "containerized.master.env.";
    public static final String CONTAINERIZED_TASK_MANAGER_ENV_PREFIX = "containerized.taskmanager.env.";

    private ResourceManagerOptions() {
    }
}

