/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class SimpleVersionedSerialization {
    public static <T> void writeVersionAndSerialize(SimpleVersionedSerializer<T> serializer, T datum, DataOutputView out) throws IOException {
        Preconditions.checkNotNull(serializer, "serializer");
        Preconditions.checkNotNull(datum, "datum");
        Preconditions.checkNotNull(out, "out");
        byte[] data = serializer.serialize(datum);
        out.writeInt(serializer.getVersion());
        out.writeInt(data.length);
        out.write(data);
    }

    public static <T> T readVersionAndDeSerialize(SimpleVersionedSerializer<T> serializer, DataInputView in) throws IOException {
        Preconditions.checkNotNull(serializer, "serializer");
        Preconditions.checkNotNull(in, "in");
        int version = in.readInt();
        int length = in.readInt();
        byte[] data = new byte[length];
        in.readFully(data);
        return serializer.deserialize(version, data);
    }

    public static <T> byte[] writeVersionAndSerialize(SimpleVersionedSerializer<T> serializer, T datum) throws IOException {
        Preconditions.checkNotNull(serializer, "serializer");
        Preconditions.checkNotNull(datum, "datum");
        byte[] data = serializer.serialize(datum);
        byte[] versionAndData = new byte[data.length + 8];
        int version = serializer.getVersion();
        versionAndData[0] = (byte)(version >> 24);
        versionAndData[1] = (byte)(version >> 16);
        versionAndData[2] = (byte)(version >> 8);
        versionAndData[3] = (byte)version;
        int length = data.length;
        versionAndData[4] = (byte)(length >> 24);
        versionAndData[5] = (byte)(length >> 16);
        versionAndData[6] = (byte)(length >> 8);
        versionAndData[7] = (byte)length;
        System.arraycopy(data, 0, versionAndData, 8, data.length);
        return versionAndData;
    }

    public static <T> T readVersionAndDeSerialize(SimpleVersionedSerializer<T> serializer, byte[] bytes) throws IOException {
        Preconditions.checkNotNull(serializer, "serializer");
        Preconditions.checkNotNull(bytes, "bytes");
        Preconditions.checkArgument(bytes.length >= 4, "byte array below minimum length (4 bytes)");
        byte[] dataOnly = Arrays.copyOfRange(bytes, 8, bytes.length);
        int version = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        int length = (bytes[4] & 0xFF) << 24 | (bytes[5] & 0xFF) << 16 | (bytes[6] & 0xFF) << 8 | bytes[7] & 0xFF;
        if (length == dataOnly.length) {
            return serializer.deserialize(version, dataOnly);
        }
        throw new IOException("Corrupt data, conflicting lengths. Length fields: " + length + ", data: " + dataOnly.length);
    }

    private SimpleVersionedSerialization() {
    }
}

