/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.java.sampling.DistributedRandomSampler;
import org.apache.flink.api.java.sampling.IntermediateSampleData;
import org.apache.flink.api.java.sampling.ReservoirSamplerWithReplacement;
import org.apache.flink.api.java.sampling.ReservoirSamplerWithoutReplacement;
import org.apache.flink.util.Collector;

@Internal
public class SampleInPartition<T>
extends RichMapPartitionFunction<T, IntermediateSampleData<T>> {
    private boolean withReplacement;
    private int numSample;
    private long seed;

    public SampleInPartition(boolean withReplacement, int numSample, long seed) {
        this.withReplacement = withReplacement;
        this.numSample = numSample;
        this.seed = seed;
    }

    public void mapPartition(Iterable<T> values, Collector<IntermediateSampleData<T>> out) throws Exception {
        long seedAndIndex = this.seed + (long)this.getRuntimeContext().getIndexOfThisSubtask();
        DistributedRandomSampler sampler = this.withReplacement ? new ReservoirSamplerWithReplacement(this.numSample, seedAndIndex) : new ReservoirSamplerWithoutReplacement(this.numSample, seedAndIndex);
        Iterator<IntermediateSampleData<T>> sampled = sampler.sampleInPartition(values.iterator());
        while (sampled.hasNext()) {
            out.collect(sampled.next());
        }
    }
}

