/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.aggregation.AggregationFunction;
import org.apache.flink.api.java.aggregation.AggregationFunctionFactory;
import org.apache.flink.api.java.aggregation.UnsupportedAggregationTypeException;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;

@Internal
public abstract class SumAggregationFunction<T>
extends AggregationFunction<T> {
    private static final long serialVersionUID = 1L;

    public String toString() {
        return "SUM";
    }

    public static final class SumAggregationFunctionFactory
    implements AggregationFunctionFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public <T> AggregationFunction<T> createAggregationFunction(Class<T> type) {
            if (type == Long.class) {
                return new LongSumAgg();
            }
            if (type == LongValue.class) {
                return new LongValueSumAgg();
            }
            if (type == Integer.class) {
                return new IntSumAgg();
            }
            if (type == IntValue.class) {
                return new IntValueSumAgg();
            }
            if (type == Double.class) {
                return new DoubleSumAgg();
            }
            if (type == DoubleValue.class) {
                return new DoubleValueSumAgg();
            }
            if (type == Float.class) {
                return new FloatSumAgg();
            }
            if (type == FloatValue.class) {
                return new FloatValueSumAgg();
            }
            if (type == Byte.class) {
                return new ByteSumAgg();
            }
            if (type == ByteValue.class) {
                return new ByteValueSumAgg();
            }
            if (type == Short.class) {
                return new ShortSumAgg();
            }
            if (type == ShortValue.class) {
                return new ShortValueSumAgg();
            }
            throw new UnsupportedAggregationTypeException("The type " + type.getName() + " is currently not supported for built-in sum aggregations.");
        }
    }

    private static final class DoubleValueSumAgg
    extends SumAggregationFunction<DoubleValue> {
        private static final long serialVersionUID = 1L;
        private double agg;

        private DoubleValueSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0.0;
        }

        @Override
        public void aggregate(DoubleValue value) {
            this.agg += value.getValue();
        }

        @Override
        public DoubleValue getAggregate() {
            return new DoubleValue(this.agg);
        }
    }

    private static final class DoubleSumAgg
    extends SumAggregationFunction<Double> {
        private static final long serialVersionUID = 1L;
        private double agg;

        private DoubleSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0.0;
        }

        @Override
        public void aggregate(Double value) {
            this.agg += value.doubleValue();
        }

        @Override
        public Double getAggregate() {
            return this.agg;
        }
    }

    private static final class FloatValueSumAgg
    extends SumAggregationFunction<FloatValue> {
        private static final long serialVersionUID = 1L;
        private double agg;

        private FloatValueSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0.0;
        }

        @Override
        public void aggregate(FloatValue value) {
            this.agg += (double)value.getValue();
        }

        @Override
        public FloatValue getAggregate() {
            return new FloatValue((float)this.agg);
        }
    }

    private static final class FloatSumAgg
    extends SumAggregationFunction<Float> {
        private static final long serialVersionUID = 1L;
        private double agg;

        private FloatSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0.0;
        }

        @Override
        public void aggregate(Float value) {
            this.agg += (double)value.floatValue();
        }

        @Override
        public Float getAggregate() {
            return Float.valueOf((float)this.agg);
        }
    }

    private static final class LongValueSumAgg
    extends SumAggregationFunction<LongValue> {
        private static final long serialVersionUID = 1L;
        private long agg;

        private LongValueSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(LongValue value) {
            this.agg += value.getValue();
        }

        @Override
        public LongValue getAggregate() {
            return new LongValue(this.agg);
        }
    }

    private static final class LongSumAgg
    extends SumAggregationFunction<Long> {
        private static final long serialVersionUID = 1L;
        private long agg;

        private LongSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(Long value) {
            this.agg += value.longValue();
        }

        @Override
        public Long getAggregate() {
            return this.agg;
        }
    }

    private static final class IntValueSumAgg
    extends SumAggregationFunction<IntValue> {
        private static final long serialVersionUID = 1L;
        private long agg;

        private IntValueSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(IntValue value) {
            this.agg += (long)value.getValue();
        }

        @Override
        public IntValue getAggregate() {
            return new IntValue((int)this.agg);
        }
    }

    private static final class IntSumAgg
    extends SumAggregationFunction<Integer> {
        private static final long serialVersionUID = 1L;
        private long agg;

        private IntSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(Integer value) {
            this.agg += (long)value.intValue();
        }

        @Override
        public Integer getAggregate() {
            return (int)this.agg;
        }
    }

    private static final class ShortValueSumAgg
    extends SumAggregationFunction<ShortValue> {
        private static final long serialVersionUID = 1L;
        private long agg;

        private ShortValueSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(ShortValue value) {
            this.agg += (long)value.getValue();
        }

        @Override
        public ShortValue getAggregate() {
            return new ShortValue((short)this.agg);
        }
    }

    private static final class ShortSumAgg
    extends SumAggregationFunction<Short> {
        private static final long serialVersionUID = 1L;
        private long agg;

        private ShortSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(Short value) {
            this.agg += (long)value.shortValue();
        }

        @Override
        public Short getAggregate() {
            return (short)this.agg;
        }
    }

    private static final class ByteValueSumAgg
    extends SumAggregationFunction<ByteValue> {
        private static final long serialVersionUID = 1L;
        private long agg;

        private ByteValueSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(ByteValue value) {
            this.agg += (long)value.getValue();
        }

        @Override
        public ByteValue getAggregate() {
            return new ByteValue((byte)this.agg);
        }
    }

    private static final class ByteSumAgg
    extends SumAggregationFunction<Byte> {
        private static final long serialVersionUID = 1L;
        private long agg;

        private ByteSumAgg() {
        }

        @Override
        public void initializeAggregate() {
            this.agg = 0L;
        }

        @Override
        public void aggregate(Byte value) {
            this.agg += (long)value.byteValue();
        }

        @Override
        public Byte getAggregate() {
            return (byte)this.agg;
        }
    }
}

