/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.events;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.model.MicroTimeBuilder;
import io.fabric8.kubernetes.api.model.MicroTimeFluentImpl;
import io.fabric8.kubernetes.api.model.events.EventSeries;
import io.fabric8.kubernetes.api.model.events.EventSeriesFluent;

public class EventSeriesFluentImpl<A extends EventSeriesFluent<A>>
extends BaseFluent<A>
implements EventSeriesFluent<A> {
    private Integer count;
    private MicroTimeBuilder lastObservedTime;
    private String state;

    public EventSeriesFluentImpl() {
    }

    public EventSeriesFluentImpl(EventSeries instance) {
        this.withCount(instance.getCount());
        this.withLastObservedTime(instance.getLastObservedTime());
        this.withState(instance.getState());
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    @Override
    public Boolean hasCount() {
        return this.count != null;
    }

    @Override
    @Deprecated
    public MicroTime getLastObservedTime() {
        return this.lastObservedTime != null ? this.lastObservedTime.build() : null;
    }

    @Override
    public MicroTime buildLastObservedTime() {
        return this.lastObservedTime != null ? this.lastObservedTime.build() : null;
    }

    @Override
    public A withLastObservedTime(MicroTime lastObservedTime) {
        this._visitables.get("lastObservedTime").remove(this.lastObservedTime);
        if (lastObservedTime != null) {
            this.lastObservedTime = new MicroTimeBuilder(lastObservedTime);
            this._visitables.get("lastObservedTime").add(this.lastObservedTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastObservedTime() {
        return this.lastObservedTime != null;
    }

    @Override
    public A withNewLastObservedTime(String time) {
        return this.withLastObservedTime(new MicroTime(time));
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> withNewLastObservedTime() {
        return new LastObservedTimeNestedImpl();
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> withNewLastObservedTimeLike(MicroTime item) {
        return new LastObservedTimeNestedImpl(item);
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> editLastObservedTime() {
        return this.withNewLastObservedTimeLike(this.getLastObservedTime());
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> editOrNewLastObservedTime() {
        return this.withNewLastObservedTimeLike(this.getLastObservedTime() != null ? this.getLastObservedTime() : new MicroTimeBuilder().build());
    }

    @Override
    public EventSeriesFluent.LastObservedTimeNested<A> editOrNewLastObservedTimeLike(MicroTime item) {
        return this.withNewLastObservedTimeLike(this.getLastObservedTime() != null ? this.getLastObservedTime() : item);
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public A withState(String state) {
        this.state = state;
        return (A)this;
    }

    @Override
    public Boolean hasState() {
        return this.state != null;
    }

    @Override
    public A withNewState(String arg1) {
        return this.withState(new String(arg1));
    }

    @Override
    public A withNewState(StringBuilder arg1) {
        return this.withState(new String(arg1));
    }

    @Override
    public A withNewState(StringBuffer arg1) {
        return this.withState(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSeriesFluentImpl that = (EventSeriesFluentImpl)o;
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.lastObservedTime != null ? !this.lastObservedTime.equals(that.lastObservedTime) : that.lastObservedTime != null) {
            return false;
        }
        return !(this.state != null ? !this.state.equals(that.state) : that.state != null);
    }

    public class LastObservedTimeNestedImpl<N>
    extends MicroTimeFluentImpl<EventSeriesFluent.LastObservedTimeNested<N>>
    implements EventSeriesFluent.LastObservedTimeNested<N>,
    Nested<N> {
        private final MicroTimeBuilder builder;

        LastObservedTimeNestedImpl(MicroTime item) {
            this.builder = new MicroTimeBuilder(this, item);
        }

        LastObservedTimeNestedImpl() {
            this.builder = new MicroTimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventSeriesFluentImpl.this.withLastObservedTime(this.builder.build());
        }

        @Override
        public N endLastObservedTime() {
            return this.and();
        }
    }
}

