/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.entrypoint;

import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.KubernetesResourceManagerDriver;
import org.apache.flink.kubernetes.KubernetesWorkerNode;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesResourceManagerDriverConfiguration;
import org.apache.flink.kubernetes.entrypoint.KubernetesWorkerResourceSpecFactory;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClientFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpecFactory;
import org.apache.flink.runtime.resourcemanager.active.ActiveResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.util.ConfigurationException;

public class KubernetesResourceManagerFactory
extends ActiveResourceManagerFactory<KubernetesWorkerNode> {
    private static final KubernetesResourceManagerFactory INSTANCE = new KubernetesResourceManagerFactory();
    private static final Time POD_CREATION_RETRY_INTERVAL = Time.seconds((long)3L);

    private KubernetesResourceManagerFactory() {
    }

    public static KubernetesResourceManagerFactory getInstance() {
        return INSTANCE;
    }

    protected ResourceManagerDriver<KubernetesWorkerNode> createResourceManagerDriver(Configuration configuration, @Nullable String webInterfaceUrl, String rpcAddress) {
        KubernetesResourceManagerDriverConfiguration kubernetesResourceManagerDriverConfiguration = new KubernetesResourceManagerDriverConfiguration(configuration.getString(KubernetesConfigOptions.CLUSTER_ID), POD_CREATION_RETRY_INTERVAL);
        return new KubernetesResourceManagerDriver(configuration, FlinkKubeClientFactory.getInstance().fromConfiguration(configuration, "resourcemanager"), kubernetesResourceManagerDriverConfiguration);
    }

    protected ResourceManagerRuntimeServicesConfiguration createResourceManagerRuntimeServicesConfiguration(Configuration configuration) throws ConfigurationException {
        return ResourceManagerRuntimeServicesConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpecFactory)KubernetesWorkerResourceSpecFactory.INSTANCE);
    }
}

