/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesLeaderElectionConfiguration;
import org.apache.flink.kubernetes.highavailability.KubernetesCheckpointRecoveryFactory;
import org.apache.flink.kubernetes.highavailability.KubernetesLeaderElectionDriverFactory;
import org.apache.flink.kubernetes.highavailability.KubernetesLeaderRetrievalDriverFactory;
import org.apache.flink.kubernetes.highavailability.KubernetesRunningJobsRegistry;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.AbstractHaServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.DefaultLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class KubernetesHaServices
extends AbstractHaServices {
    private final String clusterId;
    private final FlinkKubeClient kubeClient;
    private static final String RESOURCE_MANAGER_NAME = "resourcemanager";
    private static final String DISPATCHER_NAME = "dispatcher";
    private static final String JOB_MANAGER_NAME = "jobmanager";
    private static final String REST_SERVER_NAME = "restserver";
    private static final String LEADER_SUFFIX = "leader";
    private final String lockIdentity;

    KubernetesHaServices(FlinkKubeClient kubeClient, Executor executor, Configuration config, BlobStoreService blobStoreService) {
        super(config, executor, blobStoreService);
        this.kubeClient = (FlinkKubeClient)Preconditions.checkNotNull((Object)kubeClient);
        this.clusterId = (String)Preconditions.checkNotNull((Object)config.get(KubernetesConfigOptions.CLUSTER_ID));
        this.lockIdentity = UUID.randomUUID().toString();
    }

    public LeaderElectionService createLeaderElectionService(String leaderName) {
        KubernetesLeaderElectionConfiguration leaderConfig = new KubernetesLeaderElectionConfiguration(leaderName, this.lockIdentity, this.configuration);
        return new DefaultLeaderElectionService((LeaderElectionDriverFactory)new KubernetesLeaderElectionDriverFactory(this.kubeClient, leaderConfig));
    }

    public LeaderRetrievalService createLeaderRetrievalService(String leaderName) {
        return new DefaultLeaderRetrievalService((LeaderRetrievalDriverFactory)new KubernetesLeaderRetrievalDriverFactory(this.kubeClient, leaderName));
    }

    public CheckpointRecoveryFactory createCheckpointRecoveryFactory() {
        return new KubernetesCheckpointRecoveryFactory(this.kubeClient, this.configuration, this.ioExecutor, this::getLeaderNameForJobManager, this.lockIdentity);
    }

    public JobGraphStore createJobGraphStore() throws Exception {
        return KubernetesUtils.createJobGraphStore(this.configuration, this.kubeClient, this.getLeaderNameForDispatcher(), this.lockIdentity);
    }

    public RunningJobsRegistry createRunningJobsRegistry() {
        return new KubernetesRunningJobsRegistry(this.kubeClient, this.getLeaderNameForDispatcher(), this.lockIdentity);
    }

    public void internalClose() {
        this.kubeClient.close();
    }

    public void internalCleanup() throws Exception {
        this.kubeClient.deleteConfigMapsByLabels(KubernetesUtils.getConfigMapLabels(this.clusterId, "high-availability")).get();
    }

    public void internalCleanupJobData(JobID jobID) throws Exception {
        this.kubeClient.deleteConfigMap(this.getLeaderNameForJobManager(jobID)).get();
    }

    protected String getLeaderNameForResourceManager() {
        return this.getLeaderName(RESOURCE_MANAGER_NAME);
    }

    protected String getLeaderNameForDispatcher() {
        return this.getLeaderName(DISPATCHER_NAME);
    }

    public String getLeaderNameForJobManager(JobID jobID) {
        return this.getLeaderName(jobID.toString() + "-" + JOB_MANAGER_NAME);
    }

    protected String getLeaderNameForRestServer() {
        return this.getLeaderName(REST_SERVER_NAME);
    }

    private String getLeaderName(String component) {
        return this.clusterId + "-" + component + "-" + LEADER_SUFFIX;
    }
}

