/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.util.Arrays;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.jobmanager.JobManagerProcessSpec;
import org.apache.flink.runtime.jobmanager.JobManagerProcessUtils;
import org.apache.flink.util.Preconditions;

public class JavaCmdJobManagerDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesJobManagerParameters kubernetesJobManagerParameters;

    public JavaCmdJobManagerDecorator(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (KubernetesJobManagerParameters)Preconditions.checkNotNull((Object)kubernetesJobManagerParameters);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        JobManagerProcessSpec processSpec = JobManagerProcessUtils.processSpecFromConfigWithNewOptionToInterpretLegacyHeap((Configuration)this.kubernetesJobManagerParameters.getFlinkConfiguration(), (ConfigOption)JobManagerOptions.TOTAL_PROCESS_MEMORY);
        String startCommand = JavaCmdJobManagerDecorator.getJobManagerStartCommand(this.kubernetesJobManagerParameters.getFlinkConfiguration(), processSpec, this.kubernetesJobManagerParameters.getFlinkConfDirInPod(), this.kubernetesJobManagerParameters.getFlinkLogDirInPod(), this.kubernetesJobManagerParameters.hasLogback(), this.kubernetesJobManagerParameters.hasLog4j(), this.kubernetesJobManagerParameters.getEntrypointClass());
        Container mainContainerWithStartCmd = ((ContainerBuilder)((ContainerBuilder)new ContainerBuilder(flinkPod.getMainContainer()).withCommand(this.kubernetesJobManagerParameters.getContainerEntrypoint())).withArgs(Arrays.asList("native-k8s", startCommand))).build();
        return new FlinkPod.Builder(flinkPod).withMainContainer(mainContainerWithStartCmd).build();
    }

    private static String getJobManagerStartCommand(Configuration flinkConfig, JobManagerProcessSpec jobManagerProcessSpec, String configDirectory, String logDirectory, boolean hasLogback, boolean hasLog4j, String mainClass) {
        String jvmMemOpts = JobManagerProcessUtils.generateJvmParametersStr((JobManagerProcessSpec)jobManagerProcessSpec, (Configuration)flinkConfig);
        String dynamicParameters = JobManagerProcessUtils.generateDynamicConfigsStr((JobManagerProcessSpec)jobManagerProcessSpec);
        return KubernetesUtils.getCommonStartCommand(flinkConfig, KubernetesUtils.ClusterComponent.JOB_MANAGER, jvmMemOpts, configDirectory, logDirectory, hasLogback, hasLog4j, mainClass, dynamicParameters);
    }
}

