/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.dk.brics.automaton;

import java.util.regex.MatchResult;
import org.apache.flink.kubernetes.shaded.dk.brics.automaton.RunAutomaton;

public class AutomatonMatcher
implements MatchResult {
    private final RunAutomaton automaton;
    private final CharSequence chars;
    private int matchStart = -1;
    private int matchEnd = -1;

    AutomatonMatcher(CharSequence charSequence, RunAutomaton runAutomaton) {
        this.chars = charSequence;
        this.automaton = runAutomaton;
    }

    public boolean find() {
        int n;
        int n2;
        int n3;
        switch (this.getMatchStart()) {
            case -2: {
                return false;
            }
            case -1: {
                n3 = 0;
                break;
            }
            default: {
                n3 = this.getMatchEnd();
                if (n3 != this.getMatchStart() || ++n3 <= this.getChars().length()) break;
                this.setMatch(-2, -2);
                return false;
            }
        }
        if (this.automaton.isAccept(this.automaton.getInitialState())) {
            n2 = n3;
            n = n3;
        } else {
            n2 = -1;
            n = -1;
        }
        int n4 = this.getChars().length();
        while (n3 < n4) {
            int n5;
            int n6 = this.automaton.getInitialState();
            for (int i = n3; i < n4 && (n5 = this.automaton.step(n6, this.getChars().charAt(i))) != -1; ++i) {
                if (this.automaton.isAccept(n5)) {
                    n2 = n3;
                    n = i + 1;
                }
                n6 = n5;
            }
            if (n2 != -1) {
                this.setMatch(n2, n);
                return true;
            }
            ++n3;
        }
        if (n2 != -1) {
            this.setMatch(n2, n);
            return true;
        }
        this.setMatch(-2, -2);
        return false;
    }

    private void setMatch(int n, int n2) throws IllegalArgumentException {
        if (n > n2) {
            throw new IllegalArgumentException("Start must be less than or equal to end: " + n + ", " + n2);
        }
        this.matchStart = n;
        this.matchEnd = n2;
    }

    private int getMatchStart() {
        return this.matchStart;
    }

    private int getMatchEnd() {
        return this.matchEnd;
    }

    private CharSequence getChars() {
        return this.chars;
    }

    public int end() throws IllegalStateException {
        this.matchGood();
        return this.matchEnd;
    }

    public int end(int n) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(n);
        return this.end();
    }

    public String group() throws IllegalStateException {
        this.matchGood();
        return ((Object)this.chars.subSequence(this.matchStart, this.matchEnd)).toString();
    }

    public String group(int n) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(n);
        return this.group();
    }

    public int groupCount() {
        return 0;
    }

    public int start() throws IllegalStateException {
        this.matchGood();
        return this.matchStart;
    }

    public int start(int n) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(n);
        return this.start();
    }

    public MatchResult toMatchResult() {
        AutomatonMatcher automatonMatcher = new AutomatonMatcher(this.chars, this.automaton);
        automatonMatcher.matchStart = this.matchStart;
        automatonMatcher.matchEnd = this.matchEnd;
        return automatonMatcher;
    }

    private static void onlyZero(int n) throws IndexOutOfBoundsException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("The only group supported is 0.");
        }
    }

    private void matchGood() throws IllegalStateException {
        if (this.matchStart < 0 || this.matchEnd < 0) {
            throw new IllegalStateException("There was no available match.");
        }
    }
}

