/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TolerationBuilder;
import java.util.Map;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesToleration
extends KubernetesResource<Toleration> {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesToleration.class);

    private KubernetesToleration(Toleration toleration) {
        super(toleration);
    }

    public static KubernetesToleration fromMap(Map<String, String> stringMap) {
        TolerationBuilder tolerationBuilder = new TolerationBuilder();
        stringMap.forEach((k, v) -> {
            switch (k.toLowerCase()) {
                case "effect": {
                    tolerationBuilder.withEffect((String)v);
                    break;
                }
                case "key": {
                    tolerationBuilder.withKey((String)v);
                    break;
                }
                case "operator": {
                    tolerationBuilder.withOperator((String)v);
                    break;
                }
                case "tolerationseconds": {
                    tolerationBuilder.withTolerationSeconds(Long.valueOf(v));
                    break;
                }
                case "value": {
                    tolerationBuilder.withValue((String)v);
                    break;
                }
                default: {
                    LOG.warn("Unrecognized key({}) of toleration, will ignore.", k);
                }
            }
        });
        return new KubernetesToleration(tolerationBuilder.build());
    }
}

