/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.IterationNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public abstract class AbstractPartialSolutionNode
extends OptimizerNode {
    protected AbstractPartialSolutionNode(Operator<?> contract) {
        super(contract);
    }

    protected void copyEstimates(OptimizerNode node) {
        this.estimatedNumRecords = node.estimatedNumRecords;
        this.estimatedOutputSize = node.estimatedOutputSize;
    }

    public abstract IterationNode getIterationNode();

    @Override
    public boolean isOnDynamicPath() {
        return true;
    }

    @Override
    public void identifyDynamicPath(int costWeight) {
        this.onDynamicPath = true;
        this.costWeight = costWeight;
    }

    @Override
    public List<DagConnection> getIncomingConnections() {
        return Collections.emptyList();
    }

    @Override
    public void setInput(Map<Operator<?>, OptimizerNode> contractToNode, ExecutionMode dataExchangeMode) {
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        throw new IllegalStateException();
    }

    @Override
    public SemanticProperties getSemanticProperties() {
        return new SemanticProperties.EmptySemanticProperties();
    }

    @Override
    protected void readStubAnnotations() {
    }

    @Override
    public void accept(Visitor<OptimizerNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            visitor.postVisit((Visitable)this);
        }
    }
}

