/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.ReadOnlyByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.SlicedByteBuf;
import org.apache.flink.util.Preconditions;

public final class ReadOnlySlicedNetworkBuffer
extends ReadOnlyByteBuf
implements Buffer {
    private final int memorySegmentOffset;
    private boolean isCompressed = false;
    private Buffer.DataType dataType;

    ReadOnlySlicedNetworkBuffer(NetworkBuffer buffer, int index, int length, boolean isCompressed) {
        super((ByteBuf)new SlicedByteBuf((ByteBuf)buffer, index, length));
        this.memorySegmentOffset = buffer.getMemorySegmentOffset() + index;
        this.dataType = buffer.getDataType();
        this.isCompressed = isCompressed;
    }

    ReadOnlySlicedNetworkBuffer(ByteBuf buffer, int index, int length, int memorySegmentOffset, boolean isCompressed) {
        super((ByteBuf)new SlicedByteBuf(buffer, index, length));
        this.memorySegmentOffset = memorySegmentOffset + index;
        this.isCompressed = isCompressed;
        this.dataType = this.getBuffer().getDataType();
    }

    public ByteBuf unwrap() {
        return super.unwrap();
    }

    @Override
    public boolean isBuffer() {
        return this.dataType.isBuffer();
    }

    @Override
    public MemorySegment getMemorySegment() {
        return this.getBuffer().getMemorySegment();
    }

    @Override
    public int getMemorySegmentOffset() {
        return this.memorySegmentOffset;
    }

    @Override
    public BufferRecycler getRecycler() {
        return this.getBuffer().getRecycler();
    }

    @Override
    public void recycleBuffer() {
        this.getBuffer().recycleBuffer();
    }

    @Override
    public boolean isRecycled() {
        return this.getBuffer().isRecycled();
    }

    @Override
    public ReadOnlySlicedNetworkBuffer retainBuffer() {
        this.getBuffer().retainBuffer();
        return this;
    }

    @Override
    public ReadOnlySlicedNetworkBuffer readOnlySlice() {
        return this.readOnlySlice(this.readerIndex(), this.readableBytes());
    }

    @Override
    public ReadOnlySlicedNetworkBuffer readOnlySlice(int index, int length) {
        Preconditions.checkState((!this.isCompressed || index + length == this.writerIndex() ? 1 : 0) != 0, (Object)"Unable to partially slice a compressed buffer.");
        return new ReadOnlySlicedNetworkBuffer(super.unwrap(), index, length, this.memorySegmentOffset, this.isCompressed);
    }

    @Override
    public int getMaxCapacity() {
        return this.maxCapacity();
    }

    @Override
    public int getReaderIndex() {
        return this.readerIndex();
    }

    @Override
    public void setReaderIndex(int readerIndex) throws IndexOutOfBoundsException {
        this.readerIndex(readerIndex);
    }

    @Override
    public int getSize() {
        return this.writerIndex();
    }

    @Override
    public void setSize(int writerIndex) {
        this.writerIndex(writerIndex);
    }

    @Override
    public ByteBuffer getNioBufferReadable() {
        return this.nioBuffer();
    }

    @Override
    public ByteBuffer getNioBuffer(int index, int length) throws IndexOutOfBoundsException {
        return this.nioBuffer(index, length);
    }

    public ByteBuffer nioBuffer(int index, int length) {
        return super.nioBuffer(index, length).asReadOnlyBuffer();
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isWritable(int numBytes) {
        return false;
    }

    public ByteBuf ensureWritable(int minWritableBytes) {
        if (minWritableBytes != 0) {
            throw new ReadOnlyBufferException();
        }
        return this;
    }

    @Override
    public void setAllocator(ByteBufAllocator allocator) {
        this.getBuffer().setAllocator(allocator);
    }

    @Override
    public ByteBuf asByteBuf() {
        return this;
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public void setCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    @Override
    public Buffer.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(Buffer.DataType dataType) {
        this.dataType = dataType;
    }

    private Buffer getBuffer() {
        return (Buffer)this.unwrap().unwrap();
    }
}

