/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMasterContextImpl;
import org.apache.flink.runtime.shuffle.ShuffleServiceLoader;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;

public class JobManagerSharedServices {
    private static final Duration SHUTDOWN_TIMEOUT = Duration.ofSeconds(10L);
    private final ScheduledExecutorService futureExecutor;
    private final ExecutorService ioExecutor;
    private final LibraryCacheManager libraryCacheManager;
    private final ShuffleMaster<?> shuffleMaster;
    @Nonnull
    private final BlobWriter blobWriter;

    public JobManagerSharedServices(ScheduledExecutorService futureExecutor, ExecutorService ioExecutor, LibraryCacheManager libraryCacheManager, ShuffleMaster<?> shuffleMaster, @Nonnull BlobWriter blobWriter) {
        this.futureExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)futureExecutor);
        this.ioExecutor = (ExecutorService)Preconditions.checkNotNull((Object)ioExecutor);
        this.libraryCacheManager = (LibraryCacheManager)Preconditions.checkNotNull((Object)libraryCacheManager);
        this.shuffleMaster = (ShuffleMaster)Preconditions.checkNotNull(shuffleMaster);
        this.blobWriter = blobWriter;
    }

    public ScheduledExecutorService getFutureExecutor() {
        return this.futureExecutor;
    }

    public Executor getIoExecutor() {
        return this.ioExecutor;
    }

    public LibraryCacheManager getLibraryCacheManager() {
        return this.libraryCacheManager;
    }

    public ShuffleMaster<?> getShuffleMaster() {
        return this.shuffleMaster;
    }

    @Nonnull
    public BlobWriter getBlobWriter() {
        return this.blobWriter;
    }

    public void shutdown() throws Exception {
        Throwable exception = null;
        try {
            ExecutorUtils.gracefulShutdown((long)SHUTDOWN_TIMEOUT.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{this.futureExecutor, this.ioExecutor});
        }
        catch (Throwable t) {
            exception = t;
        }
        try {
            this.shuffleMaster.close();
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
        }
        this.libraryCacheManager.shutdown();
        if (exception != null) {
            ExceptionUtils.rethrowException((Throwable)exception, (String)"Error while shutting down JobManager services");
        }
    }

    public static JobManagerSharedServices fromConfiguration(Configuration config, BlobServer blobServer, FatalErrorHandler fatalErrorHandler) throws Exception {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)blobServer);
        String classLoaderResolveOrder = config.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns((ReadableConfig)config);
        boolean failOnJvmMetaspaceOomError = config.getBoolean(CoreOptions.FAIL_ON_USER_CLASS_LOADING_METASPACE_OOM);
        boolean checkClassLoaderLeak = config.getBoolean(CoreOptions.CHECK_LEAKED_CLASSLOADER);
        BlobLibraryCacheManager libraryCacheManager = new BlobLibraryCacheManager(blobServer, BlobLibraryCacheManager.defaultClassLoaderFactory(FlinkUserCodeClassLoaders.ResolveOrder.fromString((String)classLoaderResolveOrder), alwaysParentFirstLoaderPatterns, (FatalErrorHandler)(failOnJvmMetaspaceOomError ? fatalErrorHandler : null), checkClassLoaderLeak));
        int numberCPUCores = Hardware.getNumberCPUCores();
        int jobManagerFuturePoolSize = config.getInteger(JobManagerOptions.JOB_MANAGER_FUTURE_POOL_SIZE, numberCPUCores);
        ScheduledExecutorService futureExecutor = Executors.newScheduledThreadPool(jobManagerFuturePoolSize, (ThreadFactory)new ExecutorThreadFactory("jobmanager-future"));
        int jobManagerIoPoolSize = config.getInteger(JobManagerOptions.JOB_MANAGER_IO_POOL_SIZE, numberCPUCores);
        ExecutorService ioExecutor = Executors.newFixedThreadPool(jobManagerIoPoolSize, (ThreadFactory)new ExecutorThreadFactory("jobmanager-io"));
        ShuffleMasterContextImpl shuffleMasterContext = new ShuffleMasterContextImpl(config, fatalErrorHandler);
        ShuffleMaster<?> shuffleMaster = ShuffleServiceLoader.loadShuffleServiceFactory(config).createShuffleMaster(shuffleMasterContext);
        shuffleMaster.start();
        return new JobManagerSharedServices(futureExecutor, ioExecutor, libraryCacheManager, shuffleMaster, blobServer);
    }
}

