/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.Deque;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsConsumerId;

public interface HsSpillingInfoProvider {
    public int getNumSubpartitions();

    public List<Integer> getNextBufferIndexToConsume(HsConsumerId var1);

    public Deque<BufferIndexAndChannel> getBuffersInOrder(int var1, SpillStatus var2, ConsumeStatusWithId var3);

    public int getNumTotalUnSpillBuffers();

    public int getNumTotalRequestedBuffers();

    public int getPoolSize();

    public static class ConsumeStatusWithId {
        public static final ConsumeStatusWithId ALL_ANY = new ConsumeStatusWithId(ConsumeStatus.ALL, HsConsumerId.ANY);
        ConsumeStatus status;
        HsConsumerId consumerId;

        private ConsumeStatusWithId(ConsumeStatus status, HsConsumerId consumerId) {
            this.status = status;
            this.consumerId = consumerId;
        }

        public static ConsumeStatusWithId fromStatusAndConsumerId(ConsumeStatus consumeStatus, HsConsumerId consumerId) {
            return new ConsumeStatusWithId(consumeStatus, consumerId);
        }
    }

    public static enum ConsumeStatus {
        CONSUMED,
        NOT_CONSUMED,
        ALL;

    }

    public static enum SpillStatus {
        SPILL,
        NOT_SPILL,
        ALL;

    }
}

