/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.Preconditions;

public class CheckpointOptions
implements Serializable {
    public static final long NO_ALIGNMENT_TIME_OUT = Long.MAX_VALUE;
    private static final long serialVersionUID = 5010126558083292915L;
    private final CheckpointType checkpointType;
    private final CheckpointStorageLocationReference targetLocation;
    private final boolean isExactlyOnceMode;
    private final boolean isUnalignedCheckpoint;
    private final long alignmentTimeout;
    private static final CheckpointOptions CHECKPOINT_AT_DEFAULT_LOCATION = new CheckpointOptions(CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault());

    public static CheckpointOptions create(CheckpointType checkpointType, CheckpointStorageLocationReference locationReference, boolean isExactlyOnceMode, boolean unalignedCheckpointsEnabled, long alignmentTimeout) {
        boolean canBeUnaligned = checkpointType == CheckpointType.CHECKPOINT && unalignedCheckpointsEnabled;
        return new CheckpointOptions(checkpointType, locationReference, isExactlyOnceMode, canBeUnaligned && alignmentTimeout == 0L, canBeUnaligned ? alignmentTimeout : Long.MAX_VALUE);
    }

    @VisibleForTesting
    public CheckpointOptions(CheckpointType checkpointType, CheckpointStorageLocationReference targetLocation) {
        this(checkpointType, targetLocation, true, false, Long.MAX_VALUE);
    }

    public CheckpointOptions(CheckpointType checkpointType, CheckpointStorageLocationReference targetLocation, boolean isExactlyOnceMode, boolean isUnalignedCheckpoint, long alignmentTimeout) {
        this.checkpointType = (CheckpointType)((Object)Preconditions.checkNotNull((Object)((Object)checkpointType)));
        this.targetLocation = (CheckpointStorageLocationReference)Preconditions.checkNotNull((Object)targetLocation);
        this.isExactlyOnceMode = isExactlyOnceMode;
        this.isUnalignedCheckpoint = isUnalignedCheckpoint;
        this.alignmentTimeout = alignmentTimeout;
    }

    public boolean needsAlignment() {
        return this.isExactlyOnceMode() && (this.getCheckpointType().isSavepoint() || !this.isUnalignedCheckpoint());
    }

    public long getAlignmentTimeout() {
        return this.alignmentTimeout;
    }

    public boolean isTimeoutable() {
        return this.alignmentTimeout > 0L && this.alignmentTimeout != Long.MAX_VALUE;
    }

    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    public CheckpointStorageLocationReference getTargetLocation() {
        return this.targetLocation;
    }

    public boolean isExactlyOnceMode() {
        return this.isExactlyOnceMode;
    }

    public boolean isUnalignedCheckpoint() {
        return this.isUnalignedCheckpoint;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetLocation, this.checkpointType, this.isExactlyOnceMode, this.isUnalignedCheckpoint, this.alignmentTimeout});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == CheckpointOptions.class) {
            CheckpointOptions that = (CheckpointOptions)obj;
            return this.checkpointType == that.checkpointType && this.targetLocation.equals(that.targetLocation) && this.isExactlyOnceMode == that.isExactlyOnceMode && this.isUnalignedCheckpoint == that.isUnalignedCheckpoint && this.alignmentTimeout == that.alignmentTimeout;
        }
        return false;
    }

    public String toString() {
        return "CheckpointOptions {checkpointType = " + (Object)((Object)this.checkpointType) + ", targetLocation = " + this.targetLocation + ", isExactlyOnceMode = " + this.isExactlyOnceMode + ", isUnalignedCheckpoint = " + this.isUnalignedCheckpoint + ", alignmentTimeout = " + this.alignmentTimeout + "}";
    }

    @VisibleForTesting
    public static CheckpointOptions forCheckpointWithDefaultLocation() {
        return CHECKPOINT_AT_DEFAULT_LOCATION;
    }

    public static CheckpointOptions forCheckpointWithDefaultLocation(boolean isExactlyOnceMode, boolean isUnalignedCheckpoint, long alignmentTimeout) {
        return new CheckpointOptions(CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault(), isExactlyOnceMode, isUnalignedCheckpoint, alignmentTimeout);
    }
}

