/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RescaledChannelsMapping
implements Serializable {
    public static final RescaledChannelsMapping NO_CHANNEL_MAPPING = new RescaledChannelsMapping(Collections.emptyMap());
    private static final long serialVersionUID = -8719670050630674631L;
    private final Map<Integer, Set<Integer>> newToOldChannelIndexes;
    private transient Map<Integer, Set<Integer>> oldToNewChannelIndexes;

    public RescaledChannelsMapping(Map<Integer, Set<Integer>> newToOldChannelIndexes) {
        this.newToOldChannelIndexes = newToOldChannelIndexes;
    }

    public int[] getNewChannelIndexes(int oldChannelIndex) {
        if (this.newToOldChannelIndexes.isEmpty()) {
            return new int[]{oldChannelIndex};
        }
        if (this.oldToNewChannelIndexes == null) {
            this.oldToNewChannelIndexes = RescaledChannelsMapping.invert(this.newToOldChannelIndexes);
        }
        return this.oldToNewChannelIndexes.get(oldChannelIndex).stream().mapToInt(Integer::intValue).toArray();
    }

    public int[] getOldChannelIndexes(int newChannelIndex) {
        if (this.newToOldChannelIndexes.isEmpty()) {
            return new int[]{newChannelIndex};
        }
        return this.newToOldChannelIndexes.get(newChannelIndex).stream().mapToInt(Integer::intValue).toArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RescaledChannelsMapping that = (RescaledChannelsMapping)o;
        return this.newToOldChannelIndexes.equals(that.newToOldChannelIndexes);
    }

    public int hashCode() {
        return this.newToOldChannelIndexes.hashCode();
    }

    public String toString() {
        return "PartitionMapping{newToOldChannelIndexes=" + this.newToOldChannelIndexes + '}';
    }

    static Map<Integer, Set<Integer>> invert(Map<Integer, Set<Integer>> mapping) {
        HashMap<Integer, Set<Integer>> inverted = new HashMap<Integer, Set<Integer>>(mapping.size());
        mapping.forEach((source, targets) -> targets.forEach(target -> inverted.computeIfAbsent((Integer)target, unused -> new HashSet(targets.size())).add(source)));
        return inverted;
    }
}

