/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.util.Preconditions;

public class ResourceBudgetManager {
    private final ResourceProfile totalBudget;
    private ResourceProfile availableBudget;

    public ResourceBudgetManager(ResourceProfile totalBudget) {
        ResourceBudgetManager.checkResourceProfileNotNullOrUnknown(totalBudget);
        this.totalBudget = totalBudget;
        this.availableBudget = totalBudget;
    }

    public ResourceProfile getTotalBudget() {
        return this.totalBudget;
    }

    public ResourceProfile getAvailableBudget() {
        return this.availableBudget;
    }

    public boolean reserve(ResourceProfile reservation) {
        ResourceBudgetManager.checkResourceProfileNotNullOrUnknown(reservation);
        if (!this.availableBudget.isMatching(reservation)) {
            return false;
        }
        this.availableBudget = this.availableBudget.subtract(reservation);
        return true;
    }

    public boolean release(ResourceProfile reservation) {
        ResourceBudgetManager.checkResourceProfileNotNullOrUnknown(reservation);
        ResourceProfile newAvailableBudget = this.availableBudget.merge(reservation);
        if (!this.totalBudget.isMatching(newAvailableBudget)) {
            return false;
        }
        this.availableBudget = newAvailableBudget;
        return true;
    }

    private static void checkResourceProfileNotNullOrUnknown(ResourceProfile resourceProfile) {
        Preconditions.checkNotNull((Object)resourceProfile);
        Preconditions.checkArgument((!resourceProfile.equals(ResourceProfile.UNKNOWN) ? 1 : 0) != 0);
    }
}

