/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.Preconditions;

public class ResourceProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ResourceProfile UNKNOWN = new ResourceProfile();
    @VisibleForTesting
    public static final ResourceProfile ANY = ResourceProfile.newBuilder().setCpuCores(Double.MAX_VALUE).setTaskHeapMemory(MemorySize.MAX_VALUE).setTaskOffHeapMemory(MemorySize.MAX_VALUE).setManagedMemory(MemorySize.MAX_VALUE).setNetworkMemory(MemorySize.MAX_VALUE).build();
    public static final ResourceProfile ZERO = ResourceProfile.newBuilder().build();
    static final BigDecimal MAX_CPU_CORE_NUMBER_TO_LOG = new BigDecimal(16384);
    static final MemorySize MAX_MEMORY_SIZE_TO_LOG = new MemorySize(0x4000000000000L);
    @Nullable
    private final Resource cpuCores;
    @Nullable
    private final MemorySize taskHeapMemory;
    @Nullable
    private final MemorySize taskOffHeapMemory;
    @Nullable
    private final MemorySize managedMemory;
    @Nullable
    private final MemorySize networkMemory;
    private final Map<String, Resource> extendedResources = new HashMap<String, Resource>(1);

    private ResourceProfile(Resource cpuCores, MemorySize taskHeapMemory, MemorySize taskOffHeapMemory, MemorySize managedMemory, MemorySize networkMemory, Map<String, Resource> extendedResources) {
        Preconditions.checkNotNull((Object)cpuCores);
        Preconditions.checkArgument((boolean)(cpuCores instanceof CPUResource), (Object)"cpuCores must be CPUResource");
        this.cpuCores = cpuCores;
        this.taskHeapMemory = (MemorySize)Preconditions.checkNotNull((Object)taskHeapMemory);
        this.taskOffHeapMemory = (MemorySize)Preconditions.checkNotNull((Object)taskOffHeapMemory);
        this.managedMemory = (MemorySize)Preconditions.checkNotNull((Object)managedMemory);
        this.networkMemory = (MemorySize)Preconditions.checkNotNull((Object)networkMemory);
        if (extendedResources != null) {
            this.extendedResources.putAll(extendedResources);
        }
    }

    private ResourceProfile() {
        this.cpuCores = null;
        this.taskHeapMemory = null;
        this.taskOffHeapMemory = null;
        this.managedMemory = null;
        this.networkMemory = null;
    }

    public Resource getCpuCores() {
        this.throwUnsupportedOperationExecptionIfUnknown();
        return this.cpuCores;
    }

    public MemorySize getTaskHeapMemory() {
        this.throwUnsupportedOperationExecptionIfUnknown();
        return this.taskHeapMemory;
    }

    public MemorySize getTaskOffHeapMemory() {
        this.throwUnsupportedOperationExecptionIfUnknown();
        return this.taskOffHeapMemory;
    }

    public MemorySize getManagedMemory() {
        this.throwUnsupportedOperationExecptionIfUnknown();
        return this.managedMemory;
    }

    public MemorySize getNetworkMemory() {
        this.throwUnsupportedOperationExecptionIfUnknown();
        return this.networkMemory;
    }

    public MemorySize getTotalMemory() {
        this.throwUnsupportedOperationExecptionIfUnknown();
        return this.getOperatorsMemory().add(this.networkMemory);
    }

    public MemorySize getOperatorsMemory() {
        this.throwUnsupportedOperationExecptionIfUnknown();
        return this.taskHeapMemory.add(this.taskOffHeapMemory).add(this.managedMemory);
    }

    public Map<String, Resource> getExtendedResources() {
        this.throwUnsupportedOperationExecptionIfUnknown();
        return Collections.unmodifiableMap(this.extendedResources);
    }

    private void throwUnsupportedOperationExecptionIfUnknown() {
        if (this.equals(UNKNOWN)) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean isMatching(ResourceProfile required) {
        Preconditions.checkNotNull((Object)required, (String)"Cannot check matching with null resources");
        if (this.equals(ANY)) {
            return true;
        }
        if (this.equals(required)) {
            return true;
        }
        if (this.equals(UNKNOWN)) {
            return false;
        }
        if (required.equals(UNKNOWN)) {
            return true;
        }
        if (this.cpuCores.getValue().compareTo(required.cpuCores.getValue()) >= 0 && this.taskHeapMemory.compareTo(required.taskHeapMemory) >= 0 && this.taskOffHeapMemory.compareTo(required.taskOffHeapMemory) >= 0 && this.managedMemory.compareTo(required.managedMemory) >= 0 && this.networkMemory.compareTo(required.networkMemory) >= 0) {
            for (Map.Entry<String, Resource> resource : required.extendedResources.entrySet()) {
                if (this.extendedResources.containsKey(resource.getKey()) && this.extendedResources.get(resource.getKey()).getValue().compareTo(resource.getValue().getValue()) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.cpuCores);
        result = 31 * result + Objects.hashCode(this.taskHeapMemory);
        result = 31 * result + Objects.hashCode(this.taskOffHeapMemory);
        result = 31 * result + Objects.hashCode(this.managedMemory);
        result = 31 * result + Objects.hashCode(this.networkMemory);
        result = 31 * result + this.extendedResources.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceProfile.class) {
            ResourceProfile that = (ResourceProfile)obj;
            return Objects.equals(this.cpuCores, that.cpuCores) && Objects.equals(this.taskHeapMemory, that.taskHeapMemory) && Objects.equals(this.taskOffHeapMemory, that.taskOffHeapMemory) && Objects.equals(this.managedMemory, that.managedMemory) && Objects.equals(this.networkMemory, that.networkMemory) && Objects.equals(this.extendedResources, that.extendedResources);
        }
        return false;
    }

    @Nonnull
    public ResourceProfile merge(ResourceProfile other) {
        Preconditions.checkNotNull((Object)other, (String)"Cannot merge with null resources");
        if (this.equals(ANY) || other.equals(ANY)) {
            return ANY;
        }
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        HashMap<String, Resource> resultExtendedResource = new HashMap<String, Resource>(this.extendedResources);
        other.extendedResources.forEach((name, resource) -> resultExtendedResource.compute((String)name, (ignored, oldResource) -> oldResource == null ? resource : oldResource.merge(resource)));
        return new ResourceProfile(this.cpuCores.merge(other.cpuCores), this.taskHeapMemory.add(other.taskHeapMemory), this.taskOffHeapMemory.add(other.taskOffHeapMemory), this.managedMemory.add(other.managedMemory), this.networkMemory.add(other.networkMemory), resultExtendedResource);
    }

    public ResourceProfile subtract(ResourceProfile other) {
        Preconditions.checkNotNull((Object)other, (String)"Cannot subtract with null resources");
        if (this.equals(ANY) || other.equals(ANY)) {
            return ANY;
        }
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        Preconditions.checkArgument((boolean)this.isMatching(other), (Object)"Try to subtract an unmatched resource profile from this one.");
        HashMap<String, Resource> resultExtendedResource = new HashMap<String, Resource>(this.extendedResources);
        other.extendedResources.forEach((name, resource) -> resultExtendedResource.compute((String)name, (ignored, oldResource) -> {
            Resource resultResource = oldResource.subtract(resource);
            return resultResource.getValue().compareTo(BigDecimal.ZERO) == 0 ? null : resultResource;
        }));
        return new ResourceProfile(this.cpuCores.subtract(other.cpuCores), this.taskHeapMemory.subtract(other.taskHeapMemory), this.taskOffHeapMemory.subtract(other.taskOffHeapMemory), this.managedMemory.subtract(other.managedMemory), this.networkMemory.subtract(other.networkMemory), resultExtendedResource);
    }

    @Nonnull
    public ResourceProfile multiply(int multiplier) {
        Preconditions.checkArgument((multiplier >= 0 ? 1 : 0) != 0, (Object)"multiplier must be >= 0");
        if (this.equals(ANY)) {
            return ANY;
        }
        if (this.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        HashMap<String, Resource> resultExtendedResource = new HashMap<String, Resource>(this.extendedResources.size());
        for (Map.Entry<String, Resource> entry : this.extendedResources.entrySet()) {
            resultExtendedResource.put(entry.getKey(), entry.getValue().multiply(multiplier));
        }
        return new ResourceProfile(this.cpuCores.multiply(multiplier), this.taskHeapMemory.multiply((double)multiplier), this.taskOffHeapMemory.multiply((double)multiplier), this.managedMemory.multiply((double)multiplier), this.networkMemory.multiply((double)multiplier), resultExtendedResource);
    }

    public String toString() {
        if (this.equals(UNKNOWN)) {
            return "ResourceProfile{UNKNOWN}";
        }
        if (this.equals(ANY)) {
            return "ResourceProfile{ANY}";
        }
        StringBuilder extendedResourceStr = new StringBuilder(this.extendedResources.size() * 10);
        for (Map.Entry<String, Resource> resource : this.extendedResources.entrySet()) {
            extendedResourceStr.append(", ").append(resource.getKey()).append('=').append(resource.getValue().getValue());
        }
        return "ResourceProfile{" + this.getResourceString() + extendedResourceStr + '}';
    }

    private String getResourceString() {
        String resourceStr = this.cpuCores == null || this.cpuCores.getValue().compareTo(MAX_CPU_CORE_NUMBER_TO_LOG) > 0 ? "" : "cpuCores=" + this.cpuCores.getValue();
        resourceStr = ResourceProfile.addMemorySizeString(resourceStr, "taskHeapMemory", this.taskHeapMemory);
        resourceStr = ResourceProfile.addMemorySizeString(resourceStr, "taskOffHeapMemory", this.taskOffHeapMemory);
        resourceStr = ResourceProfile.addMemorySizeString(resourceStr, "managedMemory", this.managedMemory);
        resourceStr = ResourceProfile.addMemorySizeString(resourceStr, "networkMemory", this.networkMemory);
        return resourceStr;
    }

    private static String addMemorySizeString(String resourceStr, String name, MemorySize size) {
        String comma = resourceStr.isEmpty() ? "" : ", ";
        String memorySizeStr = size == null || size.compareTo(MAX_MEMORY_SIZE_TO_LOG) > 0 ? "" : comma + name + '=' + size.toHumanReadableString();
        return resourceStr + memorySizeStr;
    }

    private Object readResolve() {
        if (this.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        if (this.equals(ANY)) {
            return ANY;
        }
        return this;
    }

    @VisibleForTesting
    static ResourceProfile fromResourceSpec(ResourceSpec resourceSpec) {
        return ResourceProfile.fromResourceSpec(resourceSpec, MemorySize.ZERO);
    }

    public static ResourceProfile fromResourceSpec(ResourceSpec resourceSpec, MemorySize networkMemory) {
        if (ResourceSpec.UNKNOWN.equals((Object)resourceSpec)) {
            return UNKNOWN;
        }
        return ResourceProfile.newBuilder().setCpuCores(resourceSpec.getCpuCores()).setTaskHeapMemory(resourceSpec.getTaskHeapMemory()).setTaskOffHeapMemory(resourceSpec.getTaskOffHeapMemory()).setManagedMemory(resourceSpec.getManagedMemory()).setNetworkMemory(networkMemory).addExtendedResources(resourceSpec.getExtendedResources()).build();
    }

    @VisibleForTesting
    public static ResourceProfile fromResources(double cpuCores, int taskHeapMemoryMB) {
        return ResourceProfile.newBuilder().setCpuCores(cpuCores).setTaskHeapMemoryMB(taskHeapMemoryMB).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Resource cpuCores = new CPUResource(0.0);
        private MemorySize taskHeapMemory = MemorySize.ZERO;
        private MemorySize taskOffHeapMemory = MemorySize.ZERO;
        private MemorySize managedMemory = MemorySize.ZERO;
        private MemorySize networkMemory = MemorySize.ZERO;
        private Map<String, Resource> extendedResources = new HashMap<String, Resource>();

        private Builder() {
        }

        public Builder setCpuCores(Resource cpuCores) {
            this.cpuCores = cpuCores;
            return this;
        }

        public Builder setCpuCores(double cpuCores) {
            this.cpuCores = new CPUResource(cpuCores);
            return this;
        }

        public Builder setTaskHeapMemory(MemorySize taskHeapMemory) {
            this.taskHeapMemory = taskHeapMemory;
            return this;
        }

        public Builder setTaskHeapMemoryMB(int taskHeapMemoryMB) {
            this.taskHeapMemory = MemorySize.ofMebiBytes((long)taskHeapMemoryMB);
            return this;
        }

        public Builder setTaskOffHeapMemory(MemorySize taskOffHeapMemory) {
            this.taskOffHeapMemory = taskOffHeapMemory;
            return this;
        }

        public Builder setTaskOffHeapMemoryMB(int taskOffHeapMemoryMB) {
            this.taskOffHeapMemory = MemorySize.ofMebiBytes((long)taskOffHeapMemoryMB);
            return this;
        }

        public Builder setManagedMemory(MemorySize managedMemory) {
            this.managedMemory = managedMemory;
            return this;
        }

        public Builder setManagedMemoryMB(int managedMemoryMB) {
            this.managedMemory = MemorySize.ofMebiBytes((long)managedMemoryMB);
            return this;
        }

        public Builder setNetworkMemory(MemorySize networkMemory) {
            this.networkMemory = networkMemory;
            return this;
        }

        public Builder setNetworkMemoryMB(int networkMemoryMB) {
            this.networkMemory = MemorySize.ofMebiBytes((long)networkMemoryMB);
            return this;
        }

        public Builder addExtendedResource(String name, Resource extendedResource) {
            this.extendedResources.put(name, extendedResource);
            return this;
        }

        public Builder addExtendedResources(Map<String, Resource> extendedResources) {
            if (extendedResources != null) {
                this.extendedResources.putAll(extendedResources);
            }
            return this;
        }

        public ResourceProfile build() {
            return new ResourceProfile(this.cpuCores, this.taskHeapMemory, this.taskOffHeapMemory, this.managedMemory, this.networkMemory, this.extendedResources);
        }
    }
}

