/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import javax.annotation.Nullable;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.util.Preconditions;

final class DispatcherJobResult {
    private final ArchivedExecutionGraph archivedExecutionGraph;
    @Nullable
    private final Throwable initializationFailure;

    private DispatcherJobResult(ArchivedExecutionGraph archivedExecutionGraph, @Nullable Throwable throwable) {
        this.archivedExecutionGraph = archivedExecutionGraph;
        this.initializationFailure = throwable;
    }

    public boolean isInitializationFailure() {
        return this.initializationFailure != null;
    }

    public ArchivedExecutionGraph getArchivedExecutionGraph() {
        return this.archivedExecutionGraph;
    }

    public Throwable getInitializationFailure() {
        Preconditions.checkState((boolean)this.isInitializationFailure(), (Object)"This DispatcherJobResult does not represent a failed initialization.");
        return this.initializationFailure;
    }

    public static DispatcherJobResult forInitializationFailure(ArchivedExecutionGraph archivedExecutionGraph, Throwable throwable) {
        return new DispatcherJobResult(archivedExecutionGraph, throwable);
    }

    public static DispatcherJobResult forSuccess(ArchivedExecutionGraph archivedExecutionGraph) {
        return new DispatcherJobResult(archivedExecutionGraph, null);
    }
}

