/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.DeclarativeSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultSlotTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerImpl;
import org.apache.flink.util.Preconditions;

public class ResourceManagerRuntimeServices {
    private final SlotManager slotManager;
    private final JobLeaderIdService jobLeaderIdService;

    public ResourceManagerRuntimeServices(SlotManager slotManager, JobLeaderIdService jobLeaderIdService) {
        this.slotManager = (SlotManager)Preconditions.checkNotNull((Object)slotManager);
        this.jobLeaderIdService = (JobLeaderIdService)Preconditions.checkNotNull((Object)jobLeaderIdService);
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public JobLeaderIdService getJobLeaderIdService() {
        return this.jobLeaderIdService;
    }

    public static ResourceManagerRuntimeServices fromConfiguration(ResourceManagerRuntimeServicesConfiguration configuration, HighAvailabilityServices highAvailabilityServices, ScheduledExecutor scheduledExecutor, SlotManagerMetricGroup slotManagerMetricGroup) {
        SlotManager slotManager = ResourceManagerRuntimeServices.createSlotManager(configuration, scheduledExecutor, slotManagerMetricGroup);
        JobLeaderIdService jobLeaderIdService = new JobLeaderIdService(highAvailabilityServices, scheduledExecutor, configuration.getJobTimeout());
        return new ResourceManagerRuntimeServices(slotManager, jobLeaderIdService);
    }

    private static SlotManager createSlotManager(ResourceManagerRuntimeServicesConfiguration configuration, ScheduledExecutor scheduledExecutor, SlotManagerMetricGroup slotManagerMetricGroup) {
        if (configuration.isDeclarativeResourceManagementEnabled()) {
            return new DeclarativeSlotManager(scheduledExecutor, configuration.getSlotManagerConfiguration(), slotManagerMetricGroup, new DefaultResourceTracker(), new DefaultSlotTracker());
        }
        return new SlotManagerImpl(scheduledExecutor, configuration.getSlotManagerConfiguration(), slotManagerMetricGroup);
    }
}

