/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.UpperLimitExceptionParameter;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobExceptionsHandler
extends AbstractExecutionGraphHandler<JobExceptionsInfo, JobExceptionsMessageParameters>
implements JsonArchivist {
    static final int MAX_NUMBER_EXCEPTION_TO_REPORT = 20;

    public JobExceptionsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobExceptionsInfo, JobExceptionsMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected JobExceptionsInfo handleRequest(HandlerRequest<EmptyRequestBody, JobExceptionsMessageParameters> request, AccessExecutionGraph executionGraph) {
        List exceptionToReportMaxSizes = request.getQueryParameter(UpperLimitExceptionParameter.class);
        int exceptionToReportMaxSize = exceptionToReportMaxSizes.size() > 0 ? (Integer)exceptionToReportMaxSizes.get(0) : 20;
        return JobExceptionsHandler.createJobExceptionsInfo(executionGraph, exceptionToReportMaxSize);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        JobExceptionsInfo json = JobExceptionsHandler.createJobExceptionsInfo(graph, 20);
        String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString());
        return Collections.singletonList(new ArchivedJson(path, json));
    }

    private static JobExceptionsInfo createJobExceptionsInfo(AccessExecutionGraph executionGraph, int exceptionToReportMaxSize) {
        ErrorInfo rootException = executionGraph.getFailureInfo();
        String rootExceptionMessage = null;
        Long rootTimestamp = null;
        if (rootException != null) {
            rootExceptionMessage = rootException.getExceptionAsString();
            rootTimestamp = rootException.getTimestamp();
        }
        ArrayList<JobExceptionsInfo.ExecutionExceptionInfo> taskExceptionList = new ArrayList<JobExceptionsInfo.ExecutionExceptionInfo>();
        boolean truncated = false;
        for (AccessExecutionVertex accessExecutionVertex : executionGraph.getAllExecutionVertices()) {
            String t = accessExecutionVertex.getFailureCauseAsString();
            if (t == null || t.equals("(null)")) continue;
            if (taskExceptionList.size() >= exceptionToReportMaxSize) {
                truncated = true;
                break;
            }
            TaskManagerLocation location = accessExecutionVertex.getCurrentAssignedResourceLocation();
            String locationString = location != null ? location.getFQDNHostname() + ':' + location.dataPort() : "(unassigned)";
            long timestamp = accessExecutionVertex.getStateTimestamp(ExecutionState.FAILED);
            taskExceptionList.add(new JobExceptionsInfo.ExecutionExceptionInfo(t, accessExecutionVertex.getTaskNameWithSubtaskIndex(), locationString, timestamp == 0L ? -1L : timestamp));
        }
        return new JobExceptionsInfo(rootExceptionMessage, rootTimestamp, taskExceptionList, truncated);
    }
}

