/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.util.Preconditions;

class DefaultResultPartition
implements SchedulingResultPartition {
    private final IntermediateResultPartitionID resultPartitionId;
    private final IntermediateDataSetID intermediateDataSetId;
    private final ResultPartitionType partitionType;
    private final Supplier<ResultPartitionState> resultPartitionStateSupplier;
    private DefaultExecutionVertex producer;
    private final List<DefaultExecutionVertex> consumers;

    DefaultResultPartition(IntermediateResultPartitionID partitionId, IntermediateDataSetID intermediateDataSetId, ResultPartitionType partitionType, Supplier<ResultPartitionState> resultPartitionStateSupplier) {
        this.resultPartitionId = (IntermediateResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        this.intermediateDataSetId = (IntermediateDataSetID)Preconditions.checkNotNull((Object)intermediateDataSetId);
        this.partitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)partitionType)));
        this.resultPartitionStateSupplier = (Supplier)Preconditions.checkNotNull(resultPartitionStateSupplier);
        this.consumers = new ArrayList<DefaultExecutionVertex>();
    }

    @Override
    public IntermediateResultPartitionID getId() {
        return this.resultPartitionId;
    }

    @Override
    public IntermediateDataSetID getResultId() {
        return this.intermediateDataSetId;
    }

    @Override
    public ResultPartitionType getResultType() {
        return this.partitionType;
    }

    @Override
    public ResultPartitionState getState() {
        return this.resultPartitionStateSupplier.get();
    }

    @Override
    public DefaultExecutionVertex getProducer() {
        return this.producer;
    }

    @Override
    public Iterable<DefaultExecutionVertex> getConsumers() {
        return this.consumers;
    }

    void addConsumer(DefaultExecutionVertex vertex) {
        this.consumers.add((DefaultExecutionVertex)Preconditions.checkNotNull((Object)vertex));
    }

    void setProducer(DefaultExecutionVertex vertex) {
        this.producer = (DefaultExecutionVertex)Preconditions.checkNotNull((Object)vertex);
    }
}

