/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.Preconditions;

public class ZooKeeperCheckpointRecoveryFactory
implements CheckpointRecoveryFactory {
    private final CuratorFramework client;
    private final Configuration config;
    private final Executor executor;

    public ZooKeeperCheckpointRecoveryFactory(CuratorFramework client, Configuration config, Executor executor) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (String)"Curator client");
        this.config = (Configuration)Preconditions.checkNotNull((Object)config, (String)"Configuration");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (String)"Executor");
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.client.close();
    }

    @Override
    public CompletedCheckpointStore createCheckpointStore(JobID jobId, ClassLoader userClassLoader) throws Exception {
        return ZooKeeperUtils.createCompletedCheckpoints(this.client, this.config, jobId, 1, this.executor);
    }

    @Override
    public CheckpointIDCounter createCheckpointIDCounter(JobID jobID) throws Exception {
        return ZooKeeperUtils.createCheckpointIDCounter(this.client, this.config, jobID);
    }
}

