/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointLoader.class);

    public static CompletedCheckpoint loadAndValidateSavepoint(JobID jobId, Map<JobVertexID, ExecutionJobVertex> tasks, String savepointPath, ClassLoader userClassLoader, boolean allowNonRestoredState) throws IOException {
        Savepoint savepoint = SavepointStore.loadSavepoint(savepointPath, userClassLoader);
        HashMap<JobVertexID, TaskState> taskStates = new HashMap<JobVertexID, TaskState>(savepoint.getTaskStates().size());
        boolean expandedToLegacyIds = false;
        for (TaskState taskState : savepoint.getTaskStates()) {
            ExecutionJobVertex executionJobVertex = tasks.get((Object)taskState.getJobVertexID());
            if (executionJobVertex == null && !expandedToLegacyIds) {
                tasks = ExecutionJobVertex.includeLegacyJobVertexIDs(tasks);
                executionJobVertex = tasks.get((Object)taskState.getJobVertexID());
                expandedToLegacyIds = true;
                LOG.info("Could not find ExecutionJobVertex. Including legacy JobVertexIDs in search.");
            }
            if (executionJobVertex != null) {
                if (executionJobVertex.getMaxParallelism() == taskState.getMaxParallelism() || !executionJobVertex.isMaxParallelismConfigured()) {
                    taskStates.put(taskState.getJobVertexID(), taskState);
                    continue;
                }
                String msg = String.format("Failed to rollback to savepoint %s. Max parallelism mismatch between savepoint state and new program. Cannot map operator %s with max parallelism %d to new program with max parallelism %d. This indicates that the program has been changed in a non-compatible way after the savepoint.", new Object[]{savepoint, taskState.getJobVertexID(), taskState.getMaxParallelism(), executionJobVertex.getMaxParallelism()});
                throw new IllegalStateException(msg);
            }
            if (allowNonRestoredState) {
                LOG.info("Skipping savepoint state for operator {}.", (Object)taskState.getJobVertexID());
                continue;
            }
            String msg = String.format("Failed to rollback to savepoint %s. Cannot map savepoint state for operator %s to the new program, because the operator is not available in the new program. If you want to allow to skip this, you can set the --allowNonRestoredState option on the CLI.", new Object[]{savepointPath, taskState.getJobVertexID()});
            throw new IllegalStateException(msg);
        }
        CheckpointProperties props = CheckpointProperties.forStandardSavepoint();
        return new CompletedCheckpoint(jobId, savepoint.getCheckpointId(), 0L, 0L, taskStates, props, savepointPath);
    }

    private SavepointLoader() {
    }
}

