/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executors {
    private static final Logger LOG = LoggerFactory.getLogger(Executors.class);

    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    public static void gracefulShutdown(long timeout, TimeUnit unit, ExecutorService ... executorServices) {
        for (ExecutorService executorService : executorServices) {
            executorService.shutdown();
        }
        boolean wasInterrupted = false;
        long endTime = unit.toMillis(timeout) + System.currentTimeMillis();
        long timeLeft = unit.toMillis(timeout);
        boolean hasTimeLeft = timeLeft > 0L;
        for (ExecutorService executorService : executorServices) {
            if (wasInterrupted || !hasTimeLeft) {
                executorService.shutdownNow();
                continue;
            }
            try {
                if (!executorService.awaitTermination(timeLeft, TimeUnit.MILLISECONDS)) {
                    LOG.warn("ExecutorService did not terminate in time. Shutting it down now.");
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while shutting down executor services. Shutting all remaining ExecutorServices down now.", (Throwable)e);
                executorService.shutdownNow();
                wasInterrupted = true;
            }
            timeLeft = endTime - System.currentTimeMillis();
            hasTimeLeft = timeLeft > 0L;
        }
    }

    private static class DirectExecutor
    implements Executor {
        static final DirectExecutor INSTANCE = new DirectExecutor();

        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

