/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.concurrent.ApplyFunction;
import org.apache.flink.runtime.concurrent.BiFunction;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.concurrent.impl.FlinkCompletableFuture;

public class FutureUtils {
    public static <T> Future<T> retry(final Callable<Future<T>> operation, final int retries, final Executor executor) {
        Future<T> operationResultFuture;
        try {
            operationResultFuture = operation.call();
        }
        catch (Exception e) {
            return FlinkCompletableFuture.completedExceptionally(new RetryException("Could not execute the provided operation.", e));
        }
        return operationResultFuture.handleAsync(new BiFunction<T, Throwable, Future<T>>(){

            @Override
            public Future<T> apply(T t, Throwable throwable) {
                if (throwable != null) {
                    if (retries > 0) {
                        return FutureUtils.retry(operation, retries - 1, executor);
                    }
                    return FlinkCompletableFuture.completedExceptionally(new RetryException("Could not complete the operation. Number of retries has been exhausted.", throwable));
                }
                return FlinkCompletableFuture.completed(t);
            }
        }, executor).thenCompose(new ApplyFunction<Future<T>, Future<T>>(){

            @Override
            public Future<T> apply(Future<T> value) {
                return value;
            }
        });
    }

    public static class RetryException
    extends Exception {
        private static final long serialVersionUID = 3613470781274141862L;

        public RetryException(String message) {
            super(message);
        }

        public RetryException(String message, Throwable cause) {
            super(message, cause);
        }

        public RetryException(Throwable cause) {
            super(cause);
        }
    }
}

