/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.ExceptionUtils;

public class ArchivedExecution
implements AccessExecution,
Serializable {
    private static final long serialVersionUID = 4817108757483345173L;
    private final ExecutionAttemptID attemptId;
    private final long[] stateTimestamps;
    private final int attemptNumber;
    private final ExecutionState state;
    private final String failureCause;
    private final TaskManagerLocation assignedResourceLocation;
    private final StringifiedAccumulatorResult[] userAccumulators;
    private final int parallelSubtaskIndex;
    private final IOMetrics ioMetrics;

    public ArchivedExecution(Execution execution) {
        this.userAccumulators = execution.getUserAccumulatorsStringified();
        this.attemptId = execution.getAttemptId();
        this.attemptNumber = execution.getAttemptNumber();
        this.stateTimestamps = execution.getStateTimestamps();
        this.parallelSubtaskIndex = execution.getVertex().getParallelSubtaskIndex();
        this.state = execution.getState();
        this.failureCause = ExceptionUtils.stringifyException((Throwable)execution.getFailureCause());
        this.assignedResourceLocation = execution.getAssignedResourceLocation();
        this.ioMetrics = execution.getIOMetrics();
    }

    @Override
    public ExecutionAttemptID getAttemptId() {
        return this.attemptId;
    }

    @Override
    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    @Override
    public long[] getStateTimestamps() {
        return this.stateTimestamps;
    }

    @Override
    public ExecutionState getState() {
        return this.state;
    }

    @Override
    public TaskManagerLocation getAssignedResourceLocation() {
        return this.assignedResourceLocation;
    }

    @Override
    public String getFailureCauseAsString() {
        return this.failureCause;
    }

    @Override
    public long getStateTimestamp(ExecutionState state) {
        return this.stateTimestamps[state.ordinal()];
    }

    @Override
    public StringifiedAccumulatorResult[] getUserAccumulatorsStringified() {
        return this.userAccumulators;
    }

    @Override
    public int getParallelSubtaskIndex() {
        return this.parallelSubtaskIndex;
    }

    @Override
    public IOMetrics getIOMetrics() {
        return this.ioMetrics;
    }
}

