/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class ArchivedExecutionJobVertex
implements AccessExecutionJobVertex,
Serializable {
    private static final long serialVersionUID = -5768187638639437957L;
    private final ArchivedExecutionVertex[] taskVertices;
    private final JobVertexID id;
    private final String name;
    private final int parallelism;
    private final int maxParallelism;
    private final StringifiedAccumulatorResult[] archivedUserAccumulators;

    public ArchivedExecutionJobVertex(ExecutionJobVertex jobVertex) {
        this.taskVertices = new ArchivedExecutionVertex[jobVertex.getTaskVertices().length];
        for (int x = 0; x < this.taskVertices.length; ++x) {
            this.taskVertices[x] = jobVertex.getTaskVertices()[x].archive();
        }
        this.archivedUserAccumulators = jobVertex.getAggregatedUserAccumulatorsStringified();
        this.id = jobVertex.getJobVertexId();
        this.name = jobVertex.getJobVertex().getName();
        this.parallelism = jobVertex.getParallelism();
        this.maxParallelism = jobVertex.getMaxParallelism();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getParallelism() {
        return this.parallelism;
    }

    @Override
    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    @Override
    public JobVertexID getJobVertexId() {
        return this.id;
    }

    public ArchivedExecutionVertex[] getTaskVertices() {
        return this.taskVertices;
    }

    @Override
    public ExecutionState getAggregateState() {
        int[] num = new int[ExecutionState.values().length];
        for (ArchivedExecutionVertex vertex : this.taskVertices) {
            int n = vertex.getExecutionState().ordinal();
            num[n] = num[n] + 1;
        }
        return ExecutionJobVertex.getAggregateJobVertexState(num, this.parallelism);
    }

    @Override
    public StringifiedAccumulatorResult[] getAggregatedUserAccumulatorsStringified() {
        return this.archivedUserAccumulators;
    }
}

