/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.metrics.Meter;

public class IOMetrics
implements Serializable {
    private static final long serialVersionUID = -7208093607556457183L;
    private final long numRecordsIn;
    private final long numRecordsOut;
    private final double numRecordsInPerSecond;
    private final double numRecordsOutPerSecond;
    private final long numBytesInLocal;
    private final long numBytesInRemote;
    private final long numBytesOut;
    private final double numBytesInLocalPerSecond;
    private final double numBytesInRemotePerSecond;
    private final double numBytesOutPerSecond;

    public IOMetrics(Meter recordsIn, Meter recordsOut, Meter bytesLocalIn, Meter bytesRemoteIn, Meter bytesOut) {
        this.numRecordsIn = recordsIn.getCount();
        this.numRecordsInPerSecond = recordsIn.getRate();
        this.numRecordsOut = recordsOut.getCount();
        this.numRecordsOutPerSecond = recordsOut.getRate();
        this.numBytesInLocal = bytesLocalIn.getCount();
        this.numBytesInLocalPerSecond = bytesLocalIn.getRate();
        this.numBytesInRemote = bytesRemoteIn.getCount();
        this.numBytesInRemotePerSecond = bytesRemoteIn.getRate();
        this.numBytesOut = bytesOut.getCount();
        this.numBytesOutPerSecond = bytesOut.getRate();
    }

    public long getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public long getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public long getNumBytesInLocal() {
        return this.numBytesInLocal;
    }

    public long getNumBytesInRemote() {
        return this.numBytesInRemote;
    }

    public long getNumBytesInTotal() {
        return this.numBytesInLocal + this.numBytesInRemote;
    }

    public long getNumBytesOut() {
        return this.numBytesOut;
    }

    public double getNumRecordsInPerSecond() {
        return this.numRecordsInPerSecond;
    }

    public double getNumRecordsOutPerSecond() {
        return this.numRecordsOutPerSecond;
    }

    public double getNumBytesInLocalPerSecond() {
        return this.numBytesInLocalPerSecond;
    }

    public double getNumBytesInRemotePerSecond() {
        return this.numBytesInRemotePerSecond;
    }

    public double getNumBytesOutPerSecond() {
        return this.numBytesOutPerSecond;
    }
}

