/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfSuperstepEvent;
import org.apache.flink.runtime.io.network.api.TaskEventHandler;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.util.event.EventListener;

public class ResultPartitionWriter
implements EventListener<TaskEvent> {
    private final ResultPartition partition;
    private final TaskEventHandler taskEventHandler = new TaskEventHandler();

    public ResultPartitionWriter(ResultPartition partition) {
        this.partition = partition;
    }

    public ResultPartitionID getPartitionId() {
        return this.partition.getPartitionId();
    }

    public BufferProvider getBufferProvider() {
        return this.partition.getBufferProvider();
    }

    public int getNumberOfOutputChannels() {
        return this.partition.getNumberOfSubpartitions();
    }

    public int getNumTargetKeyGroups() {
        return this.partition.getNumTargetKeyGroups();
    }

    public void writeBuffer(Buffer buffer, int targetChannel) throws IOException {
        this.partition.add(buffer, targetChannel);
    }

    public void writeEvent(AbstractEvent event, int targetChannel) throws IOException {
        this.partition.add(EventSerializer.toBuffer(event), targetChannel);
    }

    public void writeEventToAllChannels(AbstractEvent event) throws IOException {
        for (int i = 0; i < this.partition.getNumberOfSubpartitions(); ++i) {
            Buffer buffer = EventSerializer.toBuffer(event);
            this.partition.add(buffer, i);
        }
    }

    public void writeEndOfSuperstep() throws IOException {
        for (int i = 0; i < this.partition.getNumberOfSubpartitions(); ++i) {
            Buffer buffer = EventSerializer.toBuffer(EndOfSuperstepEvent.INSTANCE);
            this.partition.add(buffer, i);
        }
    }

    public void subscribeToEvent(EventListener<TaskEvent> eventListener, Class<? extends TaskEvent> eventType) {
        this.taskEventHandler.subscribe(eventListener, eventType);
    }

    @Override
    public void onEvent(TaskEvent event) {
        this.taskEventHandler.publish(event);
    }
}

