/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class CoLocationConstraint {
    private final CoLocationGroup group;
    private volatile SharedSlot sharedSlot;
    private volatile ResourceID lockedLocation;

    CoLocationConstraint(CoLocationGroup group) {
        Preconditions.checkNotNull((Object)group);
        this.group = group;
    }

    public SharedSlot getSharedSlot() {
        return this.sharedSlot;
    }

    public AbstractID getGroupId() {
        return this.group.getId();
    }

    public boolean isAssigned() {
        return this.lockedLocation != null;
    }

    public boolean isAssignedAndAlive() {
        return this.lockedLocation != null && this.sharedSlot.isAlive();
    }

    public TaskManagerLocation getLocation() {
        if (this.lockedLocation != null) {
            return this.sharedSlot.getTaskManagerLocation();
        }
        throw new IllegalStateException("Location not yet locked");
    }

    public void setSharedSlot(SharedSlot newSlot) {
        Preconditions.checkNotNull((Object)newSlot);
        if (this.sharedSlot == null) {
            this.sharedSlot = newSlot;
        } else if (newSlot != this.sharedSlot) {
            if (this.lockedLocation != null && this.lockedLocation != newSlot.getTaskManagerID()) {
                throw new IllegalArgumentException("Cannot assign different location to a constraint whose location is locked.");
            }
            if (this.sharedSlot.isAlive()) {
                this.sharedSlot.releaseSlot();
            }
            this.sharedSlot = newSlot;
        }
    }

    public void lockLocation() throws IllegalStateException {
        Preconditions.checkState((this.lockedLocation == null ? 1 : 0) != 0, (Object)"Location is already locked");
        Preconditions.checkState((this.sharedSlot != null ? 1 : 0) != 0, (Object)"Cannot lock location without a slot.");
        this.lockedLocation = this.sharedSlot.getTaskManagerID();
    }

    public String toString() {
        return "CoLocation constraint id " + this.getGroupId() + " shared slot " + this.sharedSlot;
    }
}

