/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import org.apache.flink.runtime.messages.webmonitor.JobsOverview;

public class StatusOverview
extends JobsOverview {
    private static final long serialVersionUID = -729861859715105265L;
    private final int numTaskManagersConnected;
    private final int numSlotsTotal;
    private final int numSlotsAvailable;

    public StatusOverview(int numTaskManagersConnected, int numSlotsTotal, int numSlotsAvailable, int numJobsRunningOrPending, int numJobsFinished, int numJobsCancelled, int numJobsFailed) {
        super(numJobsRunningOrPending, numJobsFinished, numJobsCancelled, numJobsFailed);
        this.numTaskManagersConnected = numTaskManagersConnected;
        this.numSlotsTotal = numSlotsTotal;
        this.numSlotsAvailable = numSlotsAvailable;
    }

    public StatusOverview(int numTaskManagersConnected, int numSlotsTotal, int numSlotsAvailable, JobsOverview jobs1, JobsOverview jobs2) {
        super(jobs1, jobs2);
        this.numTaskManagersConnected = numTaskManagersConnected;
        this.numSlotsTotal = numSlotsTotal;
        this.numSlotsAvailable = numSlotsAvailable;
    }

    public int getNumTaskManagersConnected() {
        return this.numTaskManagersConnected;
    }

    public int getNumSlotsTotal() {
        return this.numSlotsTotal;
    }

    public int getNumSlotsAvailable() {
        return this.numSlotsAvailable;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StatusOverview) {
            StatusOverview that = (StatusOverview)obj;
            return this.numTaskManagersConnected == that.numTaskManagersConnected && this.numSlotsTotal == that.numSlotsTotal && this.numSlotsAvailable == that.numSlotsAvailable && this.getNumJobsRunningOrPending() == that.getNumJobsRunningOrPending() && this.getNumJobsFinished() == that.getNumJobsFinished() && this.getNumJobsCancelled() == that.getNumJobsCancelled() && this.getNumJobsFailed() == that.getNumJobsFailed();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.numTaskManagersConnected;
        result = 31 * result + this.numSlotsTotal;
        result = 31 * result + this.numSlotsAvailable;
        return result;
    }

    @Override
    public String toString() {
        return "StatusOverview {numTaskManagersConnected=" + this.numTaskManagersConnected + ", numSlotsTotal=" + this.numSlotsTotal + ", numSlotsAvailable=" + this.numSlotsAvailable + ", numJobsRunningOrPending=" + this.getNumJobsRunningOrPending() + ", numJobsFinished=" + this.getNumJobsFinished() + ", numJobsCancelled=" + this.getNumJobsCancelled() + ", numJobsFailed=" + this.getNumJobsFailed() + '}';
    }
}

