/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegistryConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MetricRegistryConfiguration.class);
    private static volatile MetricRegistryConfiguration DEFAULT_CONFIGURATION;
    private static final Pattern splitPattern;
    private final ScopeFormats scopeFormats;
    private final char delimiter;
    private final List<Tuple2<String, Configuration>> reporterConfigurations;

    public MetricRegistryConfiguration(ScopeFormats scopeFormats, char delimiter, List<Tuple2<String, Configuration>> reporterConfigurations) {
        this.scopeFormats = (ScopeFormats)Preconditions.checkNotNull((Object)scopeFormats);
        this.delimiter = delimiter;
        this.reporterConfigurations = (List)Preconditions.checkNotNull(reporterConfigurations);
    }

    public ScopeFormats getScopeFormats() {
        return this.scopeFormats;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public List<Tuple2<String, Configuration>> getReporterConfigurations() {
        return this.reporterConfigurations;
    }

    public static MetricRegistryConfiguration fromConfiguration(Configuration configuration) {
        List<Tuple2<String, Configuration>> reporterConfigurations;
        char delim;
        ScopeFormats scopeFormats;
        try {
            scopeFormats = MetricRegistryConfiguration.createScopeConfig(configuration);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse scope format, using default scope formats", (Throwable)e);
            scopeFormats = new ScopeFormats();
        }
        try {
            delim = configuration.getString("metrics.scope.delimiter", ".").charAt(0);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse delimiter, using default delimiter.", (Throwable)e);
            delim = '.';
        }
        String definedReporters = configuration.getString("metrics.reporters", null);
        if (definedReporters == null) {
            reporterConfigurations = Collections.emptyList();
        } else {
            String[] namedReporters = splitPattern.split(definedReporters);
            reporterConfigurations = new ArrayList<Tuple2<String, Configuration>>(namedReporters.length);
            for (String namedReporter : namedReporters) {
                DelegatingConfiguration delegatingConfiguration = new DelegatingConfiguration(configuration, "metrics.reporter." + namedReporter + '.');
                reporterConfigurations.add((Tuple2<String, Configuration>)Tuple2.of((Object)namedReporter, (Object)delegatingConfiguration));
            }
        }
        return new MetricRegistryConfiguration(scopeFormats, delim, reporterConfigurations);
    }

    static ScopeFormats createScopeConfig(Configuration configuration) {
        String jmFormat = configuration.getString("metrics.scope.jm", ScopeFormat.DEFAULT_SCOPE_JOBMANAGER_GROUP);
        String jmJobFormat = configuration.getString("metrics.scope.jm.job", ScopeFormat.DEFAULT_SCOPE_JOBMANAGER_JOB_GROUP);
        String tmFormat = configuration.getString("metrics.scope.tm", ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_GROUP);
        String tmJobFormat = configuration.getString("metrics.scope.tm.job", ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_JOB_GROUP);
        String taskFormat = configuration.getString("metrics.scope.task", ScopeFormat.DEFAULT_SCOPE_TASK_GROUP);
        String operatorFormat = configuration.getString("metrics.scope.operator", ScopeFormat.DEFAULT_SCOPE_OPERATOR_GROUP);
        return new ScopeFormats(jmFormat, jmJobFormat, tmFormat, tmJobFormat, taskFormat, operatorFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetricRegistryConfiguration defaultMetricRegistryConfiguration() {
        if (DEFAULT_CONFIGURATION != null) return DEFAULT_CONFIGURATION;
        Class<MetricRegistryConfiguration> clazz = MetricRegistryConfiguration.class;
        synchronized (MetricRegistryConfiguration.class) {
            if (DEFAULT_CONFIGURATION != null) return DEFAULT_CONFIGURATION;
            DEFAULT_CONFIGURATION = MetricRegistryConfiguration.fromConfiguration(new Configuration());
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT_CONFIGURATION;
        }
    }

    static {
        splitPattern = Pattern.compile("\\s*,\\s*");
    }
}

