/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetricUtils.class);
    private static final String METRIC_GROUP_STATUS_NAME = "Status";

    private MetricUtils() {
    }

    public static void instantiateNetworkMetrics(MetricGroup metrics, final NetworkEnvironment network) {
        MetricGroup status = metrics.addGroup(METRIC_GROUP_STATUS_NAME);
        MetricGroup networkGroup = status.addGroup("Network");
        networkGroup.gauge("TotalMemorySegments", (Gauge)new Gauge<Integer>(){

            public Integer getValue() {
                return network.getNetworkBufferPool().getTotalNumberOfMemorySegments();
            }
        });
        networkGroup.gauge("AvailableMemorySegments", (Gauge)new Gauge<Integer>(){

            public Integer getValue() {
                return network.getNetworkBufferPool().getNumberOfAvailableMemorySegments();
            }
        });
    }

    public static void instantiateStatusMetrics(MetricGroup metrics) {
        MetricGroup status = metrics.addGroup(METRIC_GROUP_STATUS_NAME);
        MetricGroup jvm = status.addGroup("JVM");
        MetricUtils.instantiateClassLoaderMetrics(jvm.addGroup("ClassLoader"));
        MetricUtils.instantiateGarbageCollectorMetrics(jvm.addGroup("GarbageCollector"));
        MetricUtils.instantiateMemoryMetrics(jvm.addGroup("Memory"));
        MetricUtils.instantiateThreadMetrics(jvm.addGroup("Threads"));
        MetricUtils.instantiateCPUMetrics(jvm.addGroup("CPU"));
    }

    private static void instantiateClassLoaderMetrics(MetricGroup metrics) {
        final ClassLoadingMXBean mxBean = ManagementFactory.getClassLoadingMXBean();
        metrics.gauge("ClassesLoaded", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getTotalLoadedClassCount();
            }
        });
        metrics.gauge("ClassesUnloaded", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getUnloadedClassCount();
            }
        });
    }

    private static void instantiateGarbageCollectorMetrics(MetricGroup metrics) {
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        for (final GarbageCollectorMXBean garbageCollector : garbageCollectors) {
            MetricGroup gcGroup = metrics.addGroup(garbageCollector.getName());
            gcGroup.gauge("Count", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return garbageCollector.getCollectionCount();
                }
            });
            gcGroup.gauge("Time", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return garbageCollector.getCollectionTime();
                }
            });
        }
    }

    private static void instantiateMemoryMetrics(MetricGroup metrics) {
        final MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
        MetricGroup heap = metrics.addGroup("Heap");
        heap.gauge("Used", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getHeapMemoryUsage().getUsed();
            }
        });
        heap.gauge("Committed", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getHeapMemoryUsage().getCommitted();
            }
        });
        heap.gauge("Max", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getHeapMemoryUsage().getMax();
            }
        });
        MetricGroup nonHeap = metrics.addGroup("NonHeap");
        nonHeap.gauge("Used", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        nonHeap.gauge("Committed", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        nonHeap.gauge("Max", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        List<BufferPoolMXBean> bufferMxBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (final BufferPoolMXBean bufferMxBean : bufferMxBeans) {
            MetricGroup bufferGroup = metrics.addGroup(WordUtils.capitalize((String)bufferMxBean.getName()));
            bufferGroup.gauge("Count", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return bufferMxBean.getCount();
                }
            });
            bufferGroup.gauge("MemoryUsed", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return bufferMxBean.getMemoryUsed();
                }
            });
            bufferGroup.gauge("TotalCapacity", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return bufferMxBean.getTotalCapacity();
                }
            });
        }
    }

    private static void instantiateThreadMetrics(MetricGroup metrics) {
        final ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        metrics.gauge("Count", (Gauge)new Gauge<Integer>(){

            public Integer getValue() {
                return mxBean.getThreadCount();
            }
        });
    }

    private static void instantiateCPUMetrics(MetricGroup metrics) {
        try {
            final OperatingSystemMXBean mxBean = ManagementFactory.getOperatingSystemMXBean();
            final Method fetchCPULoadMethod = Class.forName("com.sun.management.OperatingSystemMXBean").getMethod("getProcessCpuLoad", new Class[0]);
            fetchCPULoadMethod.invoke((Object)mxBean, new Object[0]);
            final Method fetchCPUTimeMethod = Class.forName("com.sun.management.OperatingSystemMXBean").getMethod("getProcessCpuTime", new Class[0]);
            fetchCPUTimeMethod.invoke((Object)mxBean, new Object[0]);
            metrics.gauge("Load", (Gauge)new Gauge<Double>(){

                public Double getValue() {
                    try {
                        return (Double)fetchCPULoadMethod.invoke((Object)mxBean, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ignored) {
                        return -1.0;
                    }
                }
            });
            metrics.gauge("Time", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    try {
                        return (Long)fetchCPUTimeMethod.invoke((Object)mxBean, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ignored) {
                        return -1L;
                    }
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ignored) {
            LOG.warn("Cannot access com.sun.management.OperatingSystemMXBean.getProcessCpuLoad() - CPU load metrics will not be available.");
            metrics.gauge("Load", (Gauge)new Gauge<Double>(){

                public Double getValue() {
                    return -1.0;
                }
            });
            metrics.gauge("Time", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return -1L;
                }
            });
        }
    }
}

