/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.standalone.StandaloneResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.JobManagerMessages$RequestRunningJobsStatus$;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.taskmanager.TaskManagerConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EnvironmentInformation;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple11;
import scala.Tuple7;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u001de\u0001B\u0001\u0003\u00015\u0011Q\u0003T8dC24E.\u001b8l\u001b&t\u0017n\u00117vgR,'O\u0003\u0002\u0004\t\u0005YQ.\u001b8jG2,8\u000f^3s\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0011\r2Lgn['j]&\u001cE.^:uKJD\u0011b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001\u0006\u000e\u0002#U\u001cXM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u0007\f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0013\t\u0019\u0002\u0003C\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001eG\u0005\t2/\u001b8hY\u0016\f5\r^8s'f\u001cH/Z7\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u000f\t{w\u000e\\3b]&\u0011A\u0005E\u0001\u0015kN,7+\u001b8hY\u0016\f5\r^8s'f\u001cH/Z7\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\rA\u0013F\u000b\t\u0003\u001f\u0001AQaE\u0013A\u0002QAQ\u0001H\u0013A\u0002uAQA\n\u0001\u0005\u00021\"\"\u0001K\u0017\t\u000bMY\u0003\u0019\u0001\u000b\t\u000b=\u0002A\u0011\t\u0019\u0002+\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u0011A#\r\u0005\u0006'9\u0002\r\u0001\u0006\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0003=QwNY'b]\u0006<WM]\"mCN\u001cX#A\u001b1\u0005Yz\u0004cA\u001c;{9\u0011a\u0004O\u0005\u0003s}\ta\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0015\u0019E.Y:t\u0015\tIt\u0004\u0005\u0002?\u007f1\u0001A!\u0003!B\u0003\u0003\u0005\tQ!\u0001H\u0005\ryF%\r\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\"\u0002!)|'-T1oC\u001e,'o\u00117bgN\u0004\u0003G\u0001#G!\r9$(\u0012\t\u0003}\u0019#\u0011\u0002Q!\u0002\u0002\u0003\u0005)\u0011A$\u0012\u0005![\u0005C\u0001\u0010J\u0013\tQuDA\u0004O_RD\u0017N\\4\u0011\u00051{U\"A'\u000b\u00059#\u0011A\u00036pE6\fg.Y4fe&\u0011\u0001+\u0014\u0002\u000b\u0015>\u0014W*\u00198bO\u0016\u0014\bb\u0002*\u0001\u0005\u0004%\taU\u0001\u0011i\u0006\u001c8.T1oC\u001e,'o\u00117bgN,\u0012\u0001\u0016\u0019\u0003+^\u00032a\u000e\u001eW!\tqt\u000bB\u0005Y3\u0006\u0005\t\u0011!B\u0001?\n\u0019q\f\n\u001a\t\ri\u0003\u0001\u0015!\u0003\\\u0003E!\u0018m]6NC:\fw-\u001a:DY\u0006\u001c8\u000f\t\u0019\u00039z\u00032a\u000e\u001e^!\tqd\fB\u0005Y3\u0006\u0005\t\u0011!B\u0001?F\u0011\u0001\n\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u0012\t1\u0002^1tW6\fg.Y4fe&\u0011QM\u0019\u0002\f)\u0006\u001c8.T1oC\u001e,'\u000fC\u0004h\u0001\t\u0007I\u0011\u00015\u0002)5,Wn\u001c:z\u0003J\u001c\u0007.\u001b<jgR\u001cE.Y:t+\u0005I\u0007G\u00016m!\r9$h\u001b\t\u0003}1$\u0011\"\u001c8\u0002\u0002\u0003\u0005)\u0011\u0001;\u0003\u0007}#3\u0007\u0003\u0004p\u0001\u0001\u0006I\u0001]\u0001\u0016[\u0016lwN]=Be\u000eD\u0017N^5ti\u000ec\u0017m]:!a\t\t8\u000fE\u00028uI\u0004\"AP:\u0005\u00135t\u0017\u0011!A\u0001\u0006\u0003!\u0018C\u0001%v!\tae/\u0003\u0002x\u001b\nyQ*Z7pef\f%o\u00195jm&\u001cH\u000fC\u0004z\u0001\t\u0007I\u0011\u0001>\u0002)I,7o\\;sG\u0016l\u0015M\\1hKJ\u001cE.Y:t+\u0005Y\bG\u0001?\u007f!\r9$( \t\u0003}y$1b`A\u0001\u0003\u0003\u0005\tQ!\u0001\u0002\u000e\t\u0019q\f\n\u001b\t\u0011\u0005\r\u0001\u0001)A\u0005\u0003\u000b\tQC]3t_V\u00148-Z'b]\u0006<WM]\"mCN\u001c\b\u0005\r\u0003\u0002\b\u0005-\u0001\u0003B\u001c;\u0003\u0013\u00012APA\u0006\t-y\u0018\u0011AA\u0001\u0002\u0003\u0015\t!!\u0004\u0012\u0007!\u000by\u0001\r\u0003\u0002\u0012\u0005}\u0001CBA\n\u00033\ti\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u0003\u0002!\rdWo\u001d;fe\u001a\u0014\u0018-\\3x_J\\\u0017\u0002BA\u000e\u0003+\u0011AC\u00127j].\u0014Vm]8ve\u000e,W*\u00198bO\u0016\u0014\bc\u0001 \u0002 \u0011a\u0011\u0011EA\u0012\u0003\u0003\u0005\tQ!\u0001\u0002&\t\u0019q\fJ\u001b\u0005\u0017}\f\t!!A\u0002\u0002\u000b\u0005\u0011QB\t\u0004\u0011\u0006\u001d\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\t\u00055\u0012QC\u0001\u0006if\u0004Xm]\u0005\u0005\u0003c\tYCA\u000bSKN|WO]2f\u0013\u0012\u0013V\r\u001e:jKZ\f'\r\\3\t\u000f\u0005U\u0002\u0001\"\u0011\u00028\u0005y1\u000f^1si*{'-T1oC\u001e,'\u000f\u0006\u0004\u0002:\u0005%\u00131\u000b\t\u0005\u0003w\t)%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u0015\t7\r^8s\u0015\t\t\u0019%\u0001\u0003bW.\f\u0017\u0002BA$\u0003{\u0011\u0001\"Q2u_J\u0014VM\u001a\u0005\t\u0003\u0017\n\u0019\u00041\u0001\u0002N\u0005)\u0011N\u001c3fqB\u0019a$a\u0014\n\u0007\u0005EsDA\u0002J]RD\u0001\"!\u0016\u00024\u0001\u0007\u0011qK\u0001\u0007gf\u001cH/Z7\u0011\t\u0005m\u0012\u0011L\u0005\u0005\u00037\niDA\u0006BGR|'oU=ti\u0016l\u0007bBA0\u0001\u0011\u0005\u0013\u0011M\u0001\u0015gR\f'\u000f\u001e*fg>,(oY3NC:\fw-\u001a:\u0015\r\u0005e\u00121MA3\u0011!\tY%!\u0018A\u0002\u00055\u0003\u0002CA+\u0003;\u0002\r!a\u0016\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l\u0005\u00012\u000f^1siR\u000b7o['b]\u0006<WM\u001d\u000b\u0007\u0003s\ti'a\u001c\t\u0011\u0005-\u0013q\ra\u0001\u0003\u001bB\u0001\"!\u0016\u0002h\u0001\u0007\u0011q\u000b\u0005\b\u0003g\u0002A\u0011AA;\u0003=9W\r^!sG\"Lg/\u001a)s_B\u001cHCBA<\u0003{\nY\t\u0005\u0003\u0002<\u0005e\u0014\u0002BA>\u0003{\u0011Q\u0001\u0015:paND\u0001\"a \u0002r\u0001\u0007\u0011\u0011Q\u0001\rCJ\u001c\u0007.\u001b<f\u00072\f7o\u001d\u0019\u0005\u0003\u0007\u000b9\t\u0005\u00038u\u0005\u0015\u0005c\u0001 \u0002\b\u0012Y\u0011\u0011RA?\u0003\u0003\u0005\tQ!\u0001u\u0005\ryFE\u000e\u0005\t\u0003\u001b\u000b\t\b1\u0001\u0002N\u0005a\u0011M]2iSZ,7i\\;oi\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0015AE4fi*{'-T1oC\u001e,'\u000f\u0015:paN$\u0002%a\u001e\u0002\u0016\u0006\u0005\u00161UA^\u0003\u007f\u000by-!8\u0002r\u0006U(\u0011\u0002B\u000e\u0005W\u0011)D!\u0012\u0003J!91'a$A\u0002\u0005]\u0005\u0007BAM\u0003;\u0003Ba\u000e\u001e\u0002\u001cB\u0019a(!(\u0005\u0017\u0005}\u0015QSA\u0001\u0002\u0003\u0015\ta\u0012\u0002\u0004?\u0012:\u0004BB\f\u0002\u0010\u0002\u0007A\u0003\u0003\u0005\u0002&\u0006=\u0005\u0019AAT\u000391W\u000f^;sK\u0016CXmY;u_J\u0004B!!+\u000286\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+\u0001\u0006d_:\u001cWO\u001d:f]RTA!!-\u00024\u0006!Q\u000f^5m\u0015\t\t),\u0001\u0003kCZ\f\u0017\u0002BA]\u0003W\u0013\u0001\"\u0012=fGV$xN\u001d\u0005\t\u0003{\u000by\t1\u0001\u0002(\u0006Q\u0011n\\#yK\u000e,Ho\u001c:\t\u0011\u0005\u0005\u0017q\u0012a\u0001\u0003\u0007\fq\"\u001b8ti\u0006t7-Z'b]\u0006<WM\u001d\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a\u0003\u0002\u0011%t7\u000f^1oG\u0016LA!!4\u0002H\ny\u0011J\\:uC:\u001cW-T1oC\u001e,'\u000f\u0003\u0005\u0002R\u0006=\u0005\u0019AAj\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002V\u0006eWBAAl\u0015\r\t\t.T\u0005\u0005\u00037\f9NA\u0005TG\",G-\u001e7fe\"A\u0011q\\AH\u0001\u0004\t\t/A\nmS\n\u0014\u0018M]=DC\u000eDW-T1oC\u001e,'\u000f\u0005\u0003\u0002d\u00065XBAAs\u0015\u0011\t9/!;\u0002\u00191L'M]1ss\u000e\f7\r[3\u000b\u0007\u0005-H!A\u0005fq\u0016\u001cW\u000f^5p]&!\u0011q^As\u0005]\u0011En\u001c2MS\n\u0014\u0018M]=DC\u000eDW-T1oC\u001e,'\u000f\u0003\u0005\u0002t\u0006=\u0005\u0019AA\u001d\u0003\u001d\t'o\u00195jm\u0016D\u0001\"a>\u0002\u0010\u0002\u0007\u0011\u0011`\u0001\u0017e\u0016\u001cH/\u0019:u'R\u0014\u0018\r^3hs\u001a\u000b7\r^8ssB!\u00111 B\u0003\u001b\t\tiP\u0003\u0003\u0002\u0000\n\u0005\u0011a\u0002:fgR\f'\u000f\u001e\u0006\u0004\u0005\u0007!\u0011AD3yK\u000e,H/[8oOJ\f\u0007\u000f[\u0005\u0005\u0005\u000f\tiP\u0001\fSKN$\u0018M\u001d;TiJ\fG/Z4z\r\u0006\u001cGo\u001c:z\u0011!\u0011Y!a$A\u0002\t5\u0011a\u0002;j[\u0016|W\u000f\u001e\t\u0005\u0005\u001f\u00119\"\u0004\u0002\u0003\u0012)!!1\u0003B\u000b\u0003!!WO]1uS>t'bAAW?%!!\u0011\u0004B\t\u000591\u0015N\\5uK\u0012+(/\u0019;j_:D\u0001B!\b\u0002\u0010\u0002\u0007!qD\u0001\u0016Y\u0016\fG-\u001a:FY\u0016\u001cG/[8o'\u0016\u0014h/[2f!\u0011\u0011\tCa\n\u000e\u0005\t\r\"b\u0001B\u0013\t\u0005qA.Z1eKJ,G.Z2uS>t\u0017\u0002\u0002B\u0015\u0005G\u0011Q\u0003T3bI\u0016\u0014X\t\\3di&|gnU3sm&\u001cW\r\u0003\u0005\u0003.\u0005=\u0005\u0019\u0001B\u0018\u0003Y\u0019XOY7jiR,GMS8c\u000fJ\f\u0007\u000f[*u_J,\u0007c\u0001'\u00032%\u0019!1G'\u0003-M+(-\\5ui\u0016$'j\u001c2He\u0006\u0004\bn\u0015;pe\u0016D\u0001Ba\u000e\u0002\u0010\u0002\u0007!\u0011H\u0001\u001aG\",7m\u001b9pS:$(+Z2pm\u0016\u0014\u0018PR1di>\u0014\u0018\u0010\u0005\u0003\u0003<\t\u0005SB\u0001B\u001f\u0015\r\u0011y\u0004B\u0001\u000bG\",7m\u001b9pS:$\u0018\u0002\u0002B\"\u0005{\u0011\u0011d\u00115fG.\u0004x.\u001b8u%\u0016\u001cwN^3ss\u001a\u000b7\r^8ss\"A!qIAH\u0001\u0004\u0011i!\u0001\nk_\n\u0014VmY8wKJLH+[7f_V$\b\u0002\u0003B&\u0003\u001f\u0003\rA!\u0014\u0002\u001f5,GO]5dgJ+w-[:uef\u0004RA\bB(\u0005'J1A!\u0015 \u0005\u0019y\u0005\u000f^5p]B!!Q\u000bB.\u001b\t\u00119FC\u0002\u0003Z\u0011\tq!\\3ue&\u001c7/\u0003\u0003\u0003^\t]#AD'fiJL7MU3hSN$(/\u001f\u0005\b\u0005C\u0002A\u0011\u0001B2\u0003M9W\r\u001e+bg.l\u0015M\\1hKJ\u0004&o\u001c9t)Q\t9H!\u001a\u0003r\tm$Q\u0011BH\u0005?\u00139La2\u0003X\"9!Ka\u0018A\u0002\t\u001d\u0004\u0007\u0002B5\u0005[\u0002Ba\u000e\u001e\u0003lA\u0019aH!\u001c\u0005\u0017\t=$QMA\u0001\u0002\u0003\u0015\ta\u0018\u0002\u0004?\u0012B\u0004\u0002\u0003B:\u0005?\u0002\rA!\u001e\u0002#Q\f7o['b]\u0006<WM]\"p]\u001aLw\rE\u0002b\u0005oJ1A!\u001fc\u0005a!\u0016m]6NC:\fw-\u001a:D_:4\u0017nZ;sCRLwN\u001c\u0005\t\u0005{\u0012y\u00061\u0001\u0003\u0000\u0005Q!/Z:pkJ\u001cW-\u0013#\u0011\t\u0005%\"\u0011Q\u0005\u0005\u0005\u0007\u000bYC\u0001\u0006SKN|WO]2f\u0013\u0012C\u0001Ba\"\u0003`\u0001\u0007!\u0011R\u0001\u0014i\u0006\u001c8.T1oC\u001e,'\u000fT8dCRLwN\u001c\t\u0004C\n-\u0015b\u0001BGE\n\u0019B+Y:l\u001b\u0006t\u0017mZ3s\u0019>\u001c\u0017\r^5p]\"A!\u0011\u0013B0\u0001\u0004\u0011\u0019*A\u0007nK6|'/_'b]\u0006<WM\u001d\t\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*\u0019!\u0011\u0014\u0003\u0002\r5,Wn\u001c:z\u0013\u0011\u0011iJa&\u0003\u001b5+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0011!\u0011\tKa\u0018A\u0002\t\r\u0016!C5p\u001b\u0006t\u0017mZ3s!\u0011\u0011)Ka-\u000e\u0005\t\u001d&\u0002\u0002BU\u0005W\u000b\u0011\"[8nC:\fw-\u001a:\u000b\t\t5&qV\u0001\u0005I&\u001c8NC\u0002\u00032\u0012\t!![8\n\t\tU&q\u0015\u0002\n\u0013>k\u0015M\\1hKJD\u0001B!/\u0003`\u0001\u0007!1X\u0001\u0013]\u0016$xo\u001c:l\u000b:4\u0018N]8o[\u0016tG\u000f\u0005\u0003\u0003>\n\rWB\u0001B`\u0015\u0011\u0011\tMa,\u0002\u000f9,Go^8sW&!!Q\u0019B`\u0005IqU\r^<pe.,eN^5s_:lWM\u001c;\t\u0011\t%'q\fa\u0001\u0005\u0017\fa\u0003\\3bI\u0016\u0014(+\u001a;sS\u00164\u0018\r\\*feZL7-\u001a\t\u0005\u0005\u001b\u0014\u0019.\u0004\u0002\u0003P*\u0019!\u0011\u001b\u0003\u0002\u001f1,\u0017\rZ3se\u0016$(/[3wC2LAA!6\u0003P\n1B*Z1eKJ\u0014V\r\u001e:jKZ\fGnU3sm&\u001cW\r\u0003\u0005\u0003L\t}\u0003\u0019\u0001B*\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0005;\fqcZ3u%\u0016\u001cx.\u001e:dK6\u000bg.Y4feB\u0013x\u000e]:\u0015\u0011\u0005]$q\u001cB}\u0005wDq!\u001fBm\u0001\u0004\u0011\t\u000f\r\u0003\u0003d\n\u001d\b\u0003B\u001c;\u0005K\u00042A\u0010Bt\t1\u0011IOa8\u0002\u0002\u0003\u0005)\u0011\u0001Bv\u0005\ryF%O\t\u0004\u0011\n5\b\u0007\u0002Bx\u0005g\u0004b!a\u0005\u0002\u001a\tE\bc\u0001 \u0003t\u0012a!Q\u001fB|\u0003\u0003\u0005\tQ!\u0001\u0002&\t!q\fJ\u00191\t1\u0011IOa8\u0002\u0002\u0007\u0005)\u0011\u0001Bv\u0011\u00199\"\u0011\u001ca\u0001)!A!\u0011\u001aBm\u0001\u0004\u0011Y\rC\u0004\u0003\u0000\u0002!\ta!\u0001\u00027\r\u0014X-\u0019;f\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o'\u0016\u0014h/[2f)\t\u0019\u0019\u0001E\u0003\u001f\u0005\u001f\u0012y\u0002C\u0004\u0004\b\u0001!\ta!\u0003\u00023%t\u0017\u000e^5bY&TX-S(G_Jl\u0017\r^\"mCN\u001cXm\u001d\u000b\u0005\u0007\u0017\u0019\t\u0002E\u0002\u001f\u0007\u001bI1aa\u0004 \u0005\u0011)f.\u001b;\t\r]\u0019)\u00011\u0001\u0015\u0011\u001d\u0019)\u0002\u0001C\u0001\u0007/\t\u0011b]3u\u001b\u0016lwN]=\u0015\t\r-1\u0011\u0004\u0005\b\u00077\u0019\u0019\u00021\u0001\u0015\u0003\u0019\u0019wN\u001c4jO\"91q\u0004\u0001\u0005\u0002\r\u0005\u0012\u0001E4fi\u0012+g-Y;mi\u000e{gNZ5h+\u0005!\u0002bBB\u0013\u0001\u0011E1qE\u0001\u0012O\u0016$(j\u001c2NC:\fw-\u001a:OC6,G\u0003BB\u0015\u0007_\u00012aNB\u0016\u0013\r\u0019i\u0003\u0010\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005-31\u0005a\u0001\u0003\u001bBqaa\r\u0001\t#\u0019)$\u0001\fhKR\u0014Vm]8ve\u000e,W*\u00198bO\u0016\u0014h*Y7f)\u0011\u0019Ica\u000e\t\u0011\u0005-3\u0011\u0007a\u0001\u0003\u001bBqaa\u000f\u0001\t#\u0019i$\u0001\bhKR\f%o\u00195jm\u0016t\u0015-\\3\u0015\t\r%2q\b\u0005\t\u0003\u0017\u001aI\u00041\u0001\u0002N!911\t\u0001\u0005\u0002\r\u0015\u0013\u0001F2veJ,g\u000e\u001e7z%Vtg.\u001b8h\u0015>\u00147/\u0006\u0002\u0004HA11\u0011JB-\u0007?rAaa\u0013\u0004V9!1QJB*\u001b\t\u0019yEC\u0002\u0004R1\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0011\n\u0007\r]s$A\u0004qC\u000e\\\u0017mZ3\n\t\rm3Q\f\u0002\t\u0013R,'/\u00192mK*\u00191qK\u0010\u0011\t\r\u000541N\u0007\u0003\u0007GRAa!\u001a\u0004h\u000511m\\7n_:T1a!\u001b\u0007\u0003\r\t\u0007/[\u0005\u0005\u0007[\u001a\u0019GA\u0003K_\nLE\tC\u0004\u0004r\u0001!\taa\u001d\u00027\u001d,GoQ;se\u0016tG\u000f\\=Sk:t\u0017N\\4K_\n\u001c(*\u0019<b)\t\u0019)\b\u0005\u0004\u0004x\re4qL\u0007\u0003\u0003_KAaa\u001f\u00020\n!A*[:u\u0011\u001d\u0019y\b\u0001C\u0001\u0007\u0003\u000bqa\u001d;pa*{'\r\u0006\u0003\u0004\f\r\r\u0005\u0002CBC\u0007{\u0002\raa\u0018\u0002\u0005%$\u0007")
public class LocalFlinkMiniCluster
extends FlinkMiniCluster {
    private final Class<? extends JobManager> jobManagerClass = JobManager.class;
    private final Class<? extends TaskManager> taskManagerClass = TaskManager.class;
    private final Class<? extends MemoryArchivist> memoryArchivistClass = MemoryArchivist.class;
    private final Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass = StandaloneResourceManager.class;

    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration generateConfiguration(Configuration userConfiguration) {
        void var2_2;
        Configuration config = this.getDefaultConfig();
        this.setDefaultCiConfig(config);
        config.addAll(userConfiguration);
        this.setMemory(config);
        this.initializeIOFormatClasses(config);
        if (!config.containsKey(QueryableStateOptions.SERVER_ENABLE.key())) {
            this.LOG().info("Disabled queryable state server");
            config.setBoolean(QueryableStateOptions.SERVER_ENABLE, false);
        }
        return var2_2;
    }

    public Class<? extends JobManager> jobManagerClass() {
        return this.jobManagerClass;
    }

    public Class<? extends TaskManager> taskManagerClass() {
        return this.taskManagerClass;
    }

    public Class<? extends MemoryArchivist> memoryArchivistClass() {
        return this.memoryArchivistClass;
    }

    public Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass() {
        return this.resourceManagerClass;
    }

    @Override
    public ActorRef startJobManager(int index, ActorSystem system) {
        Tuple11<InstanceManager, Scheduler, BlobLibraryCacheManager, RestartStrategyFactory, FiniteDuration, Object, LeaderElectionService, SubmittedJobGraphStore, CheckpointRecoveryFactory, FiniteDuration, Option<MetricRegistry>> tuple11;
        Configuration config = this.originalConfiguration().clone();
        String jobManagerName = this.getJobManagerName(index);
        String archiveName = this.getArchiveName(index);
        int jobManagerPort = config.getInteger("jobmanager.rpc.port", 6123);
        if (jobManagerPort > 0) {
            config.setInteger("jobmanager.rpc.port", jobManagerPort + index);
        }
        if ((tuple11 = JobManager$.MODULE$.createJobManagerComponents(config, this.futureExecutor(), this.ioExecutor(), this.createLeaderElectionService())) != null) {
            Tuple11 tuple112;
            InstanceManager instanceManager = (InstanceManager)tuple11._1();
            Scheduler scheduler = (Scheduler)tuple11._2();
            BlobLibraryCacheManager libraryCacheManager = (BlobLibraryCacheManager)tuple11._3();
            RestartStrategyFactory restartStrategyFactory = (RestartStrategyFactory)tuple11._4();
            FiniteDuration timeout = (FiniteDuration)tuple11._5();
            int archiveCount = BoxesRunTime.unboxToInt((Object)tuple11._6());
            LeaderElectionService leaderElectionService = (LeaderElectionService)tuple11._7();
            SubmittedJobGraphStore submittedJobGraphStore = (SubmittedJobGraphStore)tuple11._8();
            CheckpointRecoveryFactory checkpointRecoveryFactory = (CheckpointRecoveryFactory)tuple11._9();
            FiniteDuration jobRecoveryTimeout = (FiniteDuration)tuple11._10();
            Option metricsRegistry = (Option)tuple11._11();
            Tuple11 tuple113 = tuple112 = new Tuple11((Object)instanceManager, (Object)scheduler, (Object)libraryCacheManager, (Object)restartStrategyFactory, (Object)timeout, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)leaderElectionService, (Object)submittedJobGraphStore, (Object)checkpointRecoveryFactory, (Object)jobRecoveryTimeout, (Object)metricsRegistry);
            InstanceManager instanceManager2 = (InstanceManager)tuple113._1();
            Scheduler scheduler2 = (Scheduler)tuple113._2();
            BlobLibraryCacheManager libraryCacheManager2 = (BlobLibraryCacheManager)tuple113._3();
            RestartStrategyFactory restartStrategyFactory2 = (RestartStrategyFactory)tuple113._4();
            FiniteDuration timeout2 = (FiniteDuration)tuple113._5();
            int archiveCount2 = BoxesRunTime.unboxToInt((Object)tuple113._6());
            LeaderElectionService leaderElectionService2 = (LeaderElectionService)tuple113._7();
            SubmittedJobGraphStore submittedJobGraphStore2 = (SubmittedJobGraphStore)tuple113._8();
            CheckpointRecoveryFactory checkpointRecoveryFactory2 = (CheckpointRecoveryFactory)tuple113._9();
            FiniteDuration jobRecoveryTimeout2 = (FiniteDuration)tuple113._10();
            Option metricsRegistry2 = (Option)tuple113._11();
            if (config.getBoolean("local.start-webserver", false)) {
                ((MetricRegistry)metricsRegistry2.get()).startQueryService(system, null);
            }
            ActorRef archive = system.actorOf(this.getArchiveProps(this.memoryArchivistClass(), archiveCount2), archiveName);
            return system.actorOf(this.getJobManagerProps(this.jobManagerClass(), config, this.futureExecutor(), this.ioExecutor(), instanceManager2, scheduler2, libraryCacheManager2, archive, restartStrategyFactory2, timeout2, leaderElectionService2, submittedJobGraphStore2, checkpointRecoveryFactory2, jobRecoveryTimeout2, (Option<MetricRegistry>)metricsRegistry2), jobManagerName);
        }
        throw new MatchError(tuple11);
    }

    @Override
    public ActorRef startResourceManager(int index, ActorSystem system) {
        Configuration config = this.originalConfiguration().clone();
        String resourceManagerName = this.getResourceManagerName(index);
        int resourceManagerPort = config.getInteger("resourcemanager.rpc.port", 0);
        if (resourceManagerPort > 0) {
            config.setInteger("resourcemanager.rpc.port", resourceManagerPort + index);
        }
        Props resourceManagerProps = this.getResourceManagerProps(this.resourceManagerClass(), config, this.createLeaderRetrievalService());
        return system.actorOf(resourceManagerProps, resourceManagerName);
    }

    @Override
    public ActorRef startTaskManager(int index, ActorSystem system) {
        Configuration config = this.originalConfiguration().clone();
        int rpcPort = config.getInteger("taskmanager.rpc.port", 0);
        int dataPort = config.getInteger("taskmanager.data.port", 0);
        if (rpcPort > 0) {
            config.setInteger("taskmanager.rpc.port", rpcPort + index);
        }
        if (dataPort > 0) {
            config.setInteger("taskmanager.data.port", dataPort + index);
        }
        boolean localExecution = this.numTaskManagers() == 1;
        String taskManagerActorName = super.useSingleActorSystem() ? new StringBuilder().append((Object)TaskManager$.MODULE$.TASK_MANAGER_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : TaskManager$.MODULE$.TASK_MANAGER_NAME();
        ResourceID resourceID = ResourceID.generate();
        Tuple7<TaskManagerConfiguration, TaskManagerLocation, MemoryManager, IOManager, NetworkEnvironment, LeaderRetrievalService, MetricRegistry> tuple7 = TaskManager$.MODULE$.createTaskManagerComponents(config, resourceID, this.hostname(), localExecution, (Option<LeaderRetrievalService>)new Some((Object)this.createLeaderRetrievalService()));
        if (tuple7 != null) {
            Tuple7 tuple72;
            TaskManagerConfiguration taskManagerConfig = (TaskManagerConfiguration)tuple7._1();
            TaskManagerLocation taskManagerLocation = (TaskManagerLocation)tuple7._2();
            MemoryManager memoryManager = (MemoryManager)tuple7._3();
            IOManager ioManager = (IOManager)tuple7._4();
            NetworkEnvironment network = (NetworkEnvironment)tuple7._5();
            LeaderRetrievalService leaderRetrievalService = (LeaderRetrievalService)tuple7._6();
            MetricRegistry metricsRegistry = (MetricRegistry)tuple7._7();
            Tuple7 tuple73 = tuple72 = new Tuple7((Object)taskManagerConfig, (Object)taskManagerLocation, (Object)memoryManager, (Object)ioManager, (Object)network, (Object)leaderRetrievalService, (Object)metricsRegistry);
            TaskManagerConfiguration taskManagerConfig2 = (TaskManagerConfiguration)tuple73._1();
            TaskManagerLocation taskManagerLocation2 = (TaskManagerLocation)tuple73._2();
            MemoryManager memoryManager2 = (MemoryManager)tuple73._3();
            IOManager ioManager2 = (IOManager)tuple73._4();
            NetworkEnvironment network2 = (NetworkEnvironment)tuple73._5();
            LeaderRetrievalService leaderRetrievalService2 = (LeaderRetrievalService)tuple73._6();
            MetricRegistry metricsRegistry2 = (MetricRegistry)tuple73._7();
            Props props = this.getTaskManagerProps(this.taskManagerClass(), taskManagerConfig2, resourceID, taskManagerLocation2, memoryManager2, ioManager2, network2, leaderRetrievalService2, metricsRegistry2);
            if (config.getBoolean("local.start-webserver", false)) {
                metricsRegistry2.startQueryService(system, resourceID);
            }
            return system.actorOf(props, taskManagerActorName);
        }
        throw new MatchError(tuple7);
    }

    public Props getArchiveProps(Class<? extends MemoryArchivist> archiveClass, int archiveCount) {
        return JobManager$.MODULE$.getArchiveProps(archiveClass, archiveCount);
    }

    public Props getJobManagerProps(Class<? extends JobManager> jobManagerClass, Configuration configuration, Executor futureExecutor, Executor ioExecutor, InstanceManager instanceManager, Scheduler scheduler, BlobLibraryCacheManager libraryCacheManager, ActorRef archive, RestartStrategyFactory restartStrategyFactory, FiniteDuration timeout, LeaderElectionService leaderElectionService, SubmittedJobGraphStore submittedJobGraphStore, CheckpointRecoveryFactory checkpointRecoveryFactory, FiniteDuration jobRecoveryTimeout, Option<MetricRegistry> metricsRegistry) {
        return JobManager$.MODULE$.getJobManagerProps(jobManagerClass, configuration, futureExecutor, ioExecutor, instanceManager, scheduler, libraryCacheManager, archive, restartStrategyFactory, timeout, leaderElectionService, submittedJobGraphStore, checkpointRecoveryFactory, jobRecoveryTimeout, metricsRegistry);
    }

    public Props getTaskManagerProps(Class<? extends TaskManager> taskManagerClass, TaskManagerConfiguration taskManagerConfig, ResourceID resourceID, TaskManagerLocation taskManagerLocation, MemoryManager memoryManager, IOManager ioManager, NetworkEnvironment networkEnvironment, LeaderRetrievalService leaderRetrievalService, MetricRegistry metricsRegistry) {
        return TaskManager$.MODULE$.getTaskManagerProps(taskManagerClass, taskManagerConfig, resourceID, taskManagerLocation, memoryManager, ioManager, networkEnvironment, leaderRetrievalService, metricsRegistry);
    }

    public Props getResourceManagerProps(Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass, Configuration configuration, LeaderRetrievalService leaderRetrievalService) {
        return FlinkResourceManager.getResourceManagerProps(resourceManagerClass, configuration, leaderRetrievalService);
    }

    public Option<LeaderElectionService> createLeaderElectionService() {
        return None$.MODULE$;
    }

    public void initializeIOFormatClasses(Configuration configuration) {
        try {
            Method om = FileOutputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", Configuration.class);
            om.setAccessible(true);
            om.invoke(null, configuration);
        }
        catch (Exception exception) {
            this.LOG().error("Cannot (re) initialize the globally loaded defaults. Some classes might not follow the specified default behaviour.");
        }
    }

    public void setMemory(Configuration config) {
        if (config.getInteger("taskmanager.memory.size", -1) == -1) {
            int bufferSize = config.getInteger("taskmanager.memory.segment-size", 32768);
            long bufferMem = config.getLong("taskmanager.network.numberOfBuffers", 2048L) * (long)bufferSize;
            int numTaskManager = config.getInteger("local.number-taskmanager", 1);
            float memoryFraction = config.getFloat("taskmanager.memory.fraction", 0.7f);
            long memorySize = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            memorySize /= (long)(numTaskManager + 1);
            memorySize -= bufferMem;
            memorySize = (long)((double)memorySize * (double)memoryFraction);
            config.setLong("taskmanager.memory.size", memorySize >>>= 20);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getDefaultConfig() {
        void var1_1;
        Configuration config = new Configuration();
        config.setString("jobmanager.rpc.address", this.hostname());
        config.setInteger("jobmanager.rpc.port", 0);
        config.setInteger("local.number-taskmanager", 1);
        config.setInteger(NettyConfig.NUM_THREADS_CLIENT, 1);
        config.setInteger(NettyConfig.NUM_THREADS_SERVER, 2);
        return var1_1;
    }

    public String getJobManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)JobManager$.MODULE$.JOB_MANAGER_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : JobManager$.MODULE$.JOB_MANAGER_NAME();
    }

    public String getResourceManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)FlinkResourceManager.RESOURCE_MANAGER_NAME).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : FlinkResourceManager.RESOURCE_MANAGER_NAME;
    }

    public String getArchiveName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)JobManager$.MODULE$.ARCHIVE_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : JobManager$.MODULE$.ARCHIVE_NAME();
    }

    public Iterable<JobID> currentlyRunningJobs() {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future future = leader.ask(JobManagerMessages$RequestRunningJobsStatus$.MODULE$, this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.RunningJobsStatus.class));
        return (Iterable)((JobManagerMessages.RunningJobsStatus)Await$.MODULE$.result((Awaitable)future, (Duration)this.timeout())).runningJobs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JobID apply(JobStatusMessage x$3) {
                return x$3.getJobId();
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public List<JobID> getCurrentlyRunningJobsJava() {
        void var1_1;
        ArrayList list = new ArrayList();
        this.currentlyRunningJobs().foreach((Function1)new Serializable(this, list){
            public static final long serialVersionUID = 0L;
            private final ArrayList list$1;

            public final boolean apply(JobID x$1) {
                return this.list$1.add(x$1);
            }
            {
                this.list$1 = list$1;
            }
        });
        return var1_1;
    }

    public void stopJob(JobID id) {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future response = leader.ask(new JobManagerMessages.StopJob(id), this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.StoppingResponse.class));
        JobManagerMessages.StoppingResponse rc = (JobManagerMessages.StoppingResponse)Await$.MODULE$.result((Awaitable)response, (Duration)this.timeout());
        JobManagerMessages.StoppingResponse stoppingResponse = rc;
        if (stoppingResponse instanceof JobManagerMessages.StoppingFailure) {
            JobManagerMessages.StoppingFailure stoppingFailure = (JobManagerMessages.StoppingFailure)stoppingResponse;
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping the job with ID ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), stoppingFailure.cause());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, boolean singleActorSystem) {
        super(userConfiguration, singleActorSystem);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration) {
        this(userConfiguration, true);
    }
}

