/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.util.Preconditions;

public class BitSet {
    private MemorySegment memorySegment;
    private int offset;
    private int byteLength;
    private int bitLength;
    private final int BYTE_POSITION_MASK = -8;
    private final int BYTE_INDEX_MASK = 7;

    public BitSet(int byteSize) {
        Preconditions.checkArgument((byteSize > 0 ? 1 : 0) != 0, (Object)"bits size should be greater than 0.");
        this.byteLength = byteSize;
        this.bitLength = byteSize << 3;
    }

    public void setMemorySegment(MemorySegment memorySegment, int offset) {
        Preconditions.checkArgument((memorySegment != null ? 1 : 0) != 0, (Object)"MemorySegment can not be null.");
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset should be positive integer.");
        Preconditions.checkArgument((offset + this.byteLength <= memorySegment.size() ? 1 : 0) != 0, (Object)"Could not set MemorySegment, the remain buffers is not enough.");
        this.memorySegment = memorySegment;
        this.offset = offset;
    }

    public void set(int index) {
        Preconditions.checkArgument((index < this.bitLength && index >= 0 ? 1 : 0) != 0, (Object)String.format("Input Index[%d] is larger than BitSet available size[%d].", index, this.bitLength));
        int byteIndex = (index & 0xFFFFFFF8) >>> 3;
        byte current = this.memorySegment.get(this.offset + byteIndex);
        current = (byte)(current | 1 << (index & 7));
        this.memorySegment.put(this.offset + byteIndex, current);
    }

    public boolean get(int index) {
        Preconditions.checkArgument((index < this.bitLength && index >= 0 ? 1 : 0) != 0, (Object)String.format("Input Index[%d] is larger than BitSet available size[%d].", index, this.bitLength));
        int byteIndex = (index & 0xFFFFFFF8) >>> 3;
        byte current = this.memorySegment.get(this.offset + byteIndex);
        return (current & 1 << (index & 7)) != 0;
    }

    public int bitSize() {
        return this.bitLength;
    }

    public void clear() {
        for (int i = 0; i < this.byteLength; ++i) {
            this.memorySegment.put(this.offset + i, (byte)0);
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("BitSet:\n");
        output.append("\tMemorySegment:").append(this.memorySegment.size()).append("\n");
        output.append("\tOffset:").append(this.offset).append("\n");
        output.append("\tLength:").append(this.byteLength).append("\n");
        return output.toString();
    }
}

