/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateID;
import org.apache.flink.runtime.query.KvStateServerAddress;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.util.Preconditions;

public interface KvStateMessage
extends Serializable {

    public static class NotifyKvStateUnregistered
    implements KvStateMessage {
        private static final long serialVersionUID = 1L;
        private final JobID jobId;
        private final JobVertexID jobVertexId;
        private final KeyGroupRange keyGroupRange;
        private final String registrationName;

        public NotifyKvStateUnregistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName) {
            this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId, (String)"JobID");
            this.jobVertexId = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexId), (String)"JobVertexID"));
            Preconditions.checkArgument((keyGroupRange != KeyGroupRange.EMPTY_KEY_GROUP_RANGE ? 1 : 0) != 0);
            this.keyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)keyGroupRange);
            this.registrationName = (String)Preconditions.checkNotNull((Object)registrationName, (String)"Registration name");
        }

        public JobID getJobId() {
            return this.jobId;
        }

        public JobVertexID getJobVertexId() {
            return this.jobVertexId;
        }

        public KeyGroupRange getKeyGroupRange() {
            return this.keyGroupRange;
        }

        public String getRegistrationName() {
            return this.registrationName;
        }

        public String toString() {
            return "NotifyKvStateUnregistered{jobId=" + this.jobId + ", jobVertexId=" + (Object)((Object)this.jobVertexId) + ", keyGroupRange=" + this.keyGroupRange + ", registrationName='" + this.registrationName + '\'' + '}';
        }
    }

    public static class NotifyKvStateRegistered
    implements KvStateMessage {
        private static final long serialVersionUID = 1L;
        private final JobID jobId;
        private final JobVertexID jobVertexId;
        private final KeyGroupRange keyGroupRange;
        private final String registrationName;
        private final KvStateID kvStateId;
        private final KvStateServerAddress kvStateServerAddress;

        public NotifyKvStateRegistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId, KvStateServerAddress kvStateServerAddress) {
            this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId, (String)"JobID");
            this.jobVertexId = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)jobVertexId), (String)"JobVertexID"));
            Preconditions.checkArgument((keyGroupRange != KeyGroupRange.EMPTY_KEY_GROUP_RANGE ? 1 : 0) != 0);
            this.keyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)keyGroupRange);
            this.registrationName = (String)Preconditions.checkNotNull((Object)registrationName, (String)"Registration name");
            this.kvStateId = (KvStateID)((Object)Preconditions.checkNotNull((Object)((Object)kvStateId), (String)"KvStateID"));
            this.kvStateServerAddress = (KvStateServerAddress)Preconditions.checkNotNull((Object)kvStateServerAddress, (String)"KvStateServerAddress");
        }

        public JobID getJobId() {
            return this.jobId;
        }

        public JobVertexID getJobVertexId() {
            return this.jobVertexId;
        }

        public KeyGroupRange getKeyGroupRange() {
            return this.keyGroupRange;
        }

        public String getRegistrationName() {
            return this.registrationName;
        }

        public KvStateID getKvStateId() {
            return this.kvStateId;
        }

        public KvStateServerAddress getKvStateServerAddress() {
            return this.kvStateServerAddress;
        }

        public String toString() {
            return "NotifyKvStateRegistered{jobId=" + this.jobId + ", jobVertexId=" + (Object)((Object)this.jobVertexId) + ", keyGroupRange=" + this.keyGroupRange + ", registrationName='" + this.registrationName + '\'' + ", kvStateId=" + (Object)((Object)this.kvStateId) + ", kvStateServerAddress=" + this.kvStateServerAddress + '}';
        }
    }

    public static class LookupKvStateLocation
    implements KvStateMessage {
        private static final long serialVersionUID = 1L;
        private final JobID jobId;
        private final String registrationName;

        public LookupKvStateLocation(JobID jobId, String registrationName) {
            this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId, (String)"JobID");
            this.registrationName = (String)Preconditions.checkNotNull((Object)registrationName, (String)"Name");
        }

        public JobID getJobId() {
            return this.jobId;
        }

        public String getRegistrationName() {
            return this.registrationName;
        }

        public String toString() {
            return "LookupKvStateLocation{jobId=" + this.jobId + ", registrationName='" + this.registrationName + '\'' + '}';
        }
    }
}

