/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.runtime.state.KvState;

public class GenericFoldingState<N, T, ACC, W extends ValueState<ACC> & KvState<N>>
implements FoldingState<T, ACC>,
KvState<N> {
    private final W wrappedState;
    private final FoldFunction<T, ACC> foldFunction;

    public GenericFoldingState(ValueState<ACC> wrappedState, FoldFunction<T, ACC> foldFunction) {
        if (!(wrappedState instanceof KvState)) {
            throw new IllegalArgumentException("Wrapped state must be a KvState.");
        }
        this.wrappedState = wrappedState;
        this.foldFunction = foldFunction;
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        ((KvState)this.wrappedState).setCurrentNamespace(namespace);
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace) throws Exception {
        return ((KvState)this.wrappedState).getSerializedValue(serializedKeyAndNamespace);
    }

    public ACC get() throws Exception {
        return (ACC)this.wrappedState.value();
    }

    public void add(T value) throws Exception {
        Object currentValue = this.wrappedState.value();
        this.wrappedState.update(this.foldFunction.fold(currentValue, value));
    }

    public void clear() {
        this.wrappedState.clear();
    }
}

