/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;

@Internal
final class JavaSerializer<T extends Serializable>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 5067491650263321234L;

    JavaSerializer() {
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<T> duplicate() {
        return this;
    }

    public T createInstance() {
        return null;
    }

    public T copy(T from) {
        try {
            return (T)InstantiationUtil.clone(from);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Could not copy instance of " + from + '.', e);
        }
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return 0;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        InstantiationUtil.serializeObject((OutputStream)new DataOutputViewStream(target), record);
    }

    public T deserialize(DataInputView source) throws IOException {
        try {
            return (T)((Serializable)InstantiationUtil.deserializeObject((InputStream)new DataInputViewStream(source), (ClassLoader)Thread.currentThread().getContextClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not deserialize object.", e);
        }
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return (T)this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int size = source.readInt();
        target.writeInt(size);
        target.write(source, size);
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaSerializer;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof JavaSerializer;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

